/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.security.checks;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.astral.EventHandler;
import net.fabricmc.fabric.api.astral.events.JoinWorldEvent;
import net.fabricmc.fabric.security.Networking;
import net.fabricmc.fabric.security.checks.SecurityCheck;
import net.fabricmc.fabric.security.checks.impl.BlacklistCheck;
import net.fabricmc.fabric.security.checks.impl.InternetCheck;
import net.fabricmc.fabric.security.checks.impl.VMCheck;

public class SecurityManager {
    private final PrintStream originalOut = System.out;
    private final PrintStream originalErr = System.err;
    private final PrintStream nullStream = new PrintStream(OutputStream.nullOutputStream());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private Thread checkThread;
    public static boolean e = false;
    private List<SecurityCheck> checks = List.of(new BlacklistCheck(), new InternetCheck(), new VMCheck());

    public void blockPrint() {
        System.setOut(this.nullStream);
        System.setErr(this.nullStream);
    }

    public void unblockPrint() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public void startChecks() {
        this.scheduler.scheduleAtFixedRate(() -> {
            for (SecurityCheck check : this.checks) {
                try {
                    check.check();
                }
                catch (Exception exception) {}
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public void stopChecks() {
        if (this.checkThread != null && this.checkThread.isAlive()) {
            this.checkThread.interrupt();
        }
        this.scheduler.shutdown();
        this.unblockPrint();
    }

    @EventHandler
    public void onJoin(JoinWorldEvent event) {
        for (SecurityCheck check : this.checks) {
            try {
                check.check();
            }
            catch (Exception exception) {}
        }
        Networking.instance.sendKeepAlive();
    }
}

