/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.gui.theme.Theme;
import net.fabricmc.fabric.managers.SessionManager;
import net.fabricmc.fabric.security.UserConstants;
import net.fabricmc.fabric.security.Util.SystemInfo;
import net.fabricmc.fabric.security.checks.SecurityManager;
import net.fabricmc.fabric.systems.config.ConfigWrapper;
import net.fabricmc.fabric.systems.config.JsonUtils;
import net.fabricmc.fabric.systems.settings.SettingsManager;
import net.fabricmc.fabric.utils.encryption.AESUtil;

public class Networking {
    private static final String HOST = "51.38.127.0";
    private static final int PORT = 2098;
    public static Networking instance = new Networking();
    private SecurityManager sm = new SecurityManager();
    private volatile Socket socket;
    private volatile DataInputStream in;
    private volatile DataOutputStream out;
    private volatile boolean running;
    private Thread connectThread;
    private Thread listenThread;
    private Thread sendThread;
    private final BlockingQueue<String> sendQueue = new LinkedBlockingQueue<String>();

    public void start() {
        this.startConnectThread();
        this.startListenThread();
        this.startSendThread();
    }

    public boolean isConnectedTo(String ip, int port) {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed() && this.socket.getPort() == port && (this.socket.getInetAddress().getHostAddress().equals(ip) || this.socket.getInetAddress().getHostName().equalsIgnoreCase(ip));
    }

    public void startConnectThread() {
        this.connectThread = new Thread(() -> {
            while (!this.running) {
                try {
                    this.socket = new Socket(HOST, 2098);
                    this.socket.setKeepAlive(true);
                    this.in = new DataInputStream(this.socket.getInputStream());
                    this.out = new DataOutputStream(this.socket.getOutputStream());
                    this.running = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Networking.sleep(3000L);
                }
            }
        }, "Connect-Thread");
        this.connectThread.setDaemon(true);
        this.connectThread.start();
    }

    private void startListenThread() {
        this.listenThread = new Thread(() -> {
            while (true) {
                if (!this.running || this.socket == null || this.socket.isClosed()) {
                    Networking.sleep(1000L);
                    continue;
                }
                try {
                    int length = this.in.readInt();
                    if (length <= 0) continue;
                    String encrypted = this.in.readUTF();
                    String json = new AESUtil(this.generateKey()).decrypt(encrypted);
                    if (json == null || json.isBlank()) continue;
                    this.handleServerMessage(json);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.resetConnection();
                    continue;
                }
                break;
            }
        }, "Listen-Thread");
        this.listenThread.setDaemon(true);
        this.listenThread.start();
    }

    private void startSendThread() {
        this.sendThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        String plain = this.sendQueue.take();
                        if (!this.running || this.socket == null || this.socket.isClosed() || this.out == null) {
                            this.sendQueue.offer(plain);
                            this.resetConnection();
                            Networking.sleep(1000L);
                            continue;
                        }
                        this.sm.blockPrint();
                        AESUtil aes = new AESUtil(this.generateKey());
                        String encrypted = aes.encrypt(plain);
                        this.out.writeInt(encrypted.length());
                        this.out.writeUTF(encrypted);
                        this.out.flush();
                        this.sm.unblockPrint();
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.resetConnection();
                    continue;
                }
                break;
            }
        }, "Send-Thread");
        this.sendThread.setDaemon(true);
        this.sendThread.start();
    }

    public void sendPacket(Object packet) {
        String json = JsonUtils.gson.toJson(packet);
        this.sendQueue.offer(json);
    }

    private void resetConnection() {
        this.running = false;
        this.close();
        Networking.sleep(1000L);
        this.startConnectThread();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String generateKey() throws Exception {
        long segment = Instant.now().getEpochSecond() / 1800L;
        String input = SystemInfo.getNetworkAdress() + "a@jfa" + segment;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec("a@jfa".getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        byte[] hash = mac.doFinal(input.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(hash);
    }

    private void handleServerMessage(String json) {
        JsonObject resp = JsonParser.parseString((String)json).getAsJsonObject();
        String type = resp.has("id") && resp.has("sessionId") ? "auth" : (resp.has("settings") ? "settings" : (resp.has("theme") ? "theme" : (resp.has("status") && "error".equalsIgnoreCase(resp.get("status").getAsString()) ? "error" : (resp.has("config") && resp.get("config").isJsonObject() ? "config" : (resp.has("list") && resp.get("list").isJsonArray() ? "configlist" : (resp.has("message") && resp.get("message").isJsonPrimitive() ? "irc" : "unknown"))))));
        System.out.println(resp);
        switch (type) {
            case "auth": {
                String uid = resp.get("id").getAsString();
                String sid = resp.get("sessionId").getAsString();
                SessionManager.createInstance((String)UserConstants.USERNAME.getValue(), uid, SystemInfo.getWindowsHwid(), sid);
                SecurityManager.e = true;
                UserConstants.PLAN.setValue(resp.has("plan") ? resp.get("plan").getAsString() : "");
                UserConstants.USERID.setValue(uid);
                UserConstants.GUIKEY.setValue(345);
                Networking.sleep(3000L);
                this.sendGetTheme();
                this.sendGetSettings();
                this.sm.unblockPrint();
                break;
            }
            case "configlist": {
                JsonArray list = resp.getAsJsonArray("list");
                ArrayList<ConfigWrapper> wrappers = new ArrayList<ConfigWrapper>();
                for (JsonElement el : list) {
                    JsonObject item = el.getAsJsonObject();
                    String user = item.get("user").getAsString();
                    String name = item.get("name").getAsString();
                    String id = item.get("id").getAsString();
                    String description = item.get("description").getAsString();
                    wrappers.add(new ConfigWrapper(user, name, description, id, "", new JsonObject()));
                    UserConstants.configs.put(name, (ConfigWrapper)wrappers.get(wrappers.size() - 1));
                }
                break;
            }
            case "settings": {
                JsonElement raw = resp.get("settings");
                JsonObject settingsJson = raw.isJsonObject() ? raw.getAsJsonObject() : JsonParser.parseString((String)raw.getAsString()).getAsJsonObject();
                SettingsManager.loadsettings(settingsJson.toString());
                break;
            }
            case "theme": {
                JsonElement raw = resp.get("theme");
                JsonObject themeJson = raw.isJsonObject() ? raw.getAsJsonObject() : JsonParser.parseString((String)raw.getAsString()).getAsJsonObject();
                Theme.loadTheme(themeJson.toString());
                break;
            }
            case "irc": {
                String msg = resp.get("message").getAsString();
                UserConstants.ircMessages.computeIfAbsent("IRC", k -> new ArrayList()).add(msg);
                break;
            }
            case "config": {
                JsonObject outerObj;
                JsonElement innerConfig;
                JsonElement outerConfig = resp.get("config");
                if (outerConfig == null || !outerConfig.isJsonObject() || (innerConfig = (outerObj = outerConfig.getAsJsonObject()).get("config")) == null || !innerConfig.isJsonObject()) break;
                JsonObject settingsOnly = innerConfig.getAsJsonObject();
                SettingsManager.loadsettings(settingsOnly.toString());
                break;
            }
            case "error": {
                break;
            }
        }
    }

    public void sendLoginRequest(String username) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "198");
        p.addProperty("username", username);
        p.addProperty("hwid", SystemInfo.getWindowsHwid());
        p.addProperty("uuid", ClientMain.mc.method_1548().method_44717().toString());
        p.addProperty("clientbrand", ClientMain.mc.method_1547());
        p.addProperty("mcname", ClientMain.mc.method_1548().method_1676());
        this.sendPacket(p);
    }

    public void sendIRC(String message) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "403");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.addProperty("message", message);
        this.sendPacket(p);
    }

    public void sendGetConfig(String id) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "220");
        p.addProperty("action", "get");
        p.addProperty("id", id);
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        this.sendPacket(p);
    }

    public void sendKeepAlive() {
        JsonObject p = new JsonObject();
        p.addProperty("type", "366");
        p.addProperty("timestamp", (Number)System.currentTimeMillis());
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.addProperty("hwid", SystemInfo.getWindowsHwid());
        this.sendPacket(p);
    }

    public void sendGetSettings() {
        JsonObject p = new JsonObject();
        p.addProperty("type", "309");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.addProperty("action", "get");
        this.sendPacket(p);
    }

    public void sendSettings(JsonObject settings) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "309");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.addProperty("action", "put");
        p.add("settings", (JsonElement)settings);
        this.sendPacket(p);
    }

    public void sendGetTheme() {
        JsonObject p = new JsonObject();
        p.addProperty("type", "103");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.addProperty("action", "get");
        this.sendPacket(p);
    }

    public void sendTheme(JsonObject theme) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "103");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.addProperty("action", "put");
        p.add("theme", (JsonElement)theme);
        this.sendPacket(p);
    }

    public void sendConfig(JsonObject config, String name, String description, boolean isPublic) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "220");
        p.addProperty("name", name);
        p.addProperty("description", description);
        p.addProperty("public", Boolean.valueOf(isPublic));
        p.addProperty("user", UserConstants.USERNAME.getValue().toString());
        p.addProperty("action", "post");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        p.add("config", (JsonElement)config);
        this.sendPacket(p);
    }

    public void sendGetAllConfigs() {
        JsonObject p = new JsonObject();
        p.addProperty("type", "220");
        p.addProperty("action", "GETALL");
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        this.sendPacket(p);
    }

    public void sendDeleteConfig(String id) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "220");
        p.addProperty("action", "delete");
        p.addProperty("id", id);
        p.addProperty("sessionId", SessionManager.getInstance().getSessionID());
        this.sendPacket(p);
    }
}

