/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin;

import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.api.astral.events.EventMotion;
import net.fabricmc.fabric.api.astral.events.HandSwingEvent;
import net.fabricmc.fabric.api.astral.events.MoveEvent;
import net.fabricmc.fabric.api.astral.events.SendMovementPacketEvent;
import net.fabricmc.fabric.gui.setting.BooleanSetting;
import net.fabricmc.fabric.managers.ModuleManager;
import net.fabricmc.fabric.systems.module.impl.player.NoSlow;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_746.class})
public abstract class ClientPlayerMixin
extends class_1309 {
    @Shadow
    public abstract boolean method_5715();

    @Shadow
    public abstract void method_5784(class_1313 var1, class_243 var2);

    @Shadow
    public abstract float method_5695(float var1);

    protected ClientPlayerMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"swingHand"})
    public void swingHand(class_1268 hand, CallbackInfo ci) {
        if (ClientMain.getInstance().isSelfDestructed) {
            return;
        }
        HandSwingEvent event = new HandSwingEvent(hand);
        ClientMain.EVENTBUS.post(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Redirect(method={"tickMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;isUsingItem()Z"), require=0)
    private boolean tickMovement(class_746 player) {
        if (ModuleManager.INSTANCE.getModuleByClass(NoSlow.class).isEnabled() && ((BooleanSetting)ModuleManager.INSTANCE.getModuleByClass(NoSlow.class).getSettings().get(1)).isEnabled()) {
            return false;
        }
        return player.method_6115();
    }

    @Inject(method={"shouldSlowDown"}, at={@At(value="HEAD")}, cancellable=true)
    private void onShouldSlowDown(CallbackInfoReturnable<Boolean> info) {
        if (ModuleManager.INSTANCE.getModuleByClass(NoSlow.class).isEnabled() && ((BooleanSetting)ModuleManager.INSTANCE.getModuleByClass(NoSlow.class).getSettings().get(1)).isEnabled()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isSneaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsSneaking(CallbackInfoReturnable<Boolean> info) {
        if (ModuleManager.INSTANCE.getModuleByClass(NoSlow.class).isEnabled() && ((BooleanSetting)ModuleManager.INSTANCE.getModuleByClass(NoSlow.class).getSettings().get(2)).isEnabled()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/AbstractClientPlayerEntity;move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V")}, cancellable=true)
    public void onMoveHook(class_1313 movementType, class_243 movement, CallbackInfo ci) {
        if (ClientMain.getInstance().isSelfDestructed) {
            return;
        }
        MoveEvent event = new MoveEvent(movement.field_1352, movement.field_1351, movement.field_1350);
        ClientMain.EVENTBUS.post(event);
        if (event.isCancelled()) {
            this.method_5784(movementType, new class_243(event.getX(), event.getY(), event.getZ()));
            ci.cancel();
        }
    }

    @Inject(method={"sendMovementPackets"}, at={@At(value="HEAD")})
    private void onSendMovementPacketsHead(CallbackInfo info) {
        if (ClientMain.getInstance().isSelfDestructed) {
            return;
        }
        ClientMain.EVENTBUS.post(SendMovementPacketEvent.Pre.get());
        EventMotion.Pre event = EventMotion.Pre.get(ClientMain.mc.field_1724.method_36454(), ClientMain.mc.field_1724.method_36455(), ClientMain.mc.field_1724.method_23317(), ClientMain.mc.field_1724.method_23318(), ClientMain.mc.field_1724.method_23321(), ClientMain.mc.field_1724.method_24828());
        ClientMain.EVENTBUS.post(event);
        if (event.isCancelled()) {
            info.cancel();
            return;
        }
        ClientMain.mc.field_1724.method_36456(event.getYaw());
        ClientMain.mc.field_1724.method_36457(event.getPitch());
        ClientMain.mc.field_1724.method_23327(event.getPosX(), event.getPosY(), event.getPosZ());
        ClientMain.mc.field_1724.method_24830(event.isOnGround());
        event.updateLast();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V", ordinal=0)})
    private void onTickHasVehicleBeforeSendPackets(CallbackInfo info) {
        ClientMain.EVENTBUS.post(SendMovementPacketEvent.Pre.get());
    }

    @Inject(method={"sendMovementPackets"}, at={@At(value="TAIL")})
    private void onSendMovementPacketsTail(CallbackInfo info) {
        ClientMain.EVENTBUS.post(SendMovementPacketEvent.Post.get());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V", ordinal=1, shift=At.Shift.AFTER)})
    private void onTickHasVehicleAfterSendPackets(CallbackInfo info) {
        ClientMain.EVENTBUS.post(SendMovementPacketEvent.Post.get());
    }
}

