/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.managers.rotation;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.api.astral.EventHandler;
import net.fabricmc.fabric.api.astral.events.EventPlayerTravel;
import net.fabricmc.fabric.api.astral.events.EventUpdate;
import net.fabricmc.fabric.api.astral.events.InputEvent;
import net.fabricmc.fabric.api.astral.events.JumpEvent;
import net.fabricmc.fabric.api.astral.events.MoveFixEvent;
import net.fabricmc.fabric.api.astral.events.PacketEvent;
import net.fabricmc.fabric.api.astral.events.SendMovementPacketEvent;
import net.fabricmc.fabric.managers.rotation.Rotation;
import net.fabricmc.fabric.mixin.ILivingEntity;
import net.fabricmc.fabric.systems.module.impl.Client.MoveFix;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2708;
import net.minecraft.class_2828;
import net.minecraft.class_3532;

public class RotationManager {
    private final Map<Class<?>, Rotation> activeRotations = new HashMap();
    private boolean moveFix = false;
    private boolean resetRotation = false;
    private Rotation currentRotation;
    private float clientYaw = 0.0f;
    private float clientPitch = 0.0f;
    private float serverYaw = 0.0f;
    private float serverPitch = 0.0f;
    private float prevYaw;
    private MoveFixType moveFixType;
    private RotationPriority currentPriority = RotationPriority.NONE;

    public RotationManager() {
        this.moveFixType = MoveFixType.NONE;
    }

    public boolean isRotating(Class<?> sourceClass) {
        return this.activeRotations.containsKey(sourceClass);
    }

    public void removeRotation(Class<?> sourceClass) {
        this.activeRotations.remove(sourceClass);
    }

    public Rotation getServerRotation() {
        return new Rotation(this.serverYaw, this.serverPitch);
    }

    public void setRotation(Rotation rotation, RotationPriority priority) {
        Class src = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(frames -> frames.skip(1L).findFirst().map(StackWalker.StackFrame::getDeclaringClass).orElse(null));
        this.activeRotations.put(src, rotation);
        if (priority.compareTo(this.currentPriority) >= 0) {
            this.currentRotation = rotation;
            this.currentPriority = priority;
        }
    }

    public void setRotation(double yaw, double pitch, RotationPriority priority) {
        this.setRotation(new Rotation((float)yaw, (float)pitch), priority);
    }

    public void setRotation(Rotation rotation, float smoothness) {
        Rotation current = this.currentRotation != null ? this.currentRotation : this.getPlayerRotation();
        float newYaw = this.smoothAngle(current.getYaw(), rotation.getYaw(), smoothness);
        float newPitch = this.smoothAngle(current.getPitch(), rotation.getPitch(), smoothness);
        this.currentRotation = new Rotation(newYaw, newPitch);
    }

    public Rotation getPlayerRotation() {
        if (ClientMain.mc.field_1724 == null) {
            return new Rotation(0.0f, 0.0f);
        }
        return new Rotation(ClientMain.mc.field_1724.method_36454(), ClientMain.mc.field_1724.method_36455());
    }

    public boolean isRotating() {
        return this.currentRotation != null;
    }

    public void resetRotation(boolean setCurrentRotationNull) {
        Class sourceClass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(frames -> frames.skip(1L).findFirst().map(StackWalker.StackFrame::getDeclaringClass).orElse(null));
        if (!this.resetRotation) {
            this.resetRotation = true;
            this.currentRotation = null;
            this.currentPriority = RotationPriority.NONE;
            this.removeRotation(sourceClass);
            this.serverYaw = ClientMain.mc.field_1724.method_36454();
            this.serverPitch = ClientMain.mc.field_1724.method_36455();
        }
    }

    public void setMoveFix(MoveFixType moveFixType, boolean moveFix) {
        this.moveFix = moveFix;
        this.moveFixType = moveFixType;
    }

    public void resetClientRotation() {
        if (Math.abs(ClientMain.mc.field_1724.method_36454() - this.clientYaw) > 0.1f || Math.abs(ClientMain.mc.field_1724.method_36455() - this.clientPitch) > 0.1f) {
            ClientMain.mc.field_1724.method_36456(this.clientYaw);
            ClientMain.mc.field_1724.method_36457(this.clientPitch);
        }
        this.resetRotation = false;
    }

    private void setClientRotation(Rotation rotation) {
        this.clientYaw = ClientMain.mc.field_1724.method_36454();
        this.clientPitch = ClientMain.mc.field_1724.method_36455();
        ClientMain.mc.field_1724.method_36456(rotation.getYaw());
        ClientMain.mc.field_1724.method_36457(rotation.getPitch());
        this.resetRotation = true;
    }

    private void setServerRotation(Rotation rotation) {
        this.serverYaw = rotation.getYaw();
        this.serverPitch = rotation.getPitch();
    }

    @EventHandler(priority=-200)
    void onPacketSend(PacketEvent.Send event) {
        class_2596<?> class_25962 = event.packet;
        if (class_25962 instanceof class_2828) {
            class_2828 packet = (class_2828)class_25962;
            this.serverYaw = packet.method_12271(this.serverYaw);
            this.serverPitch = packet.method_12270(this.serverPitch);
        }
    }

    @EventHandler
    private void onTick(EventUpdate event) {
        if (ClientMain.mc.field_1724 == null) {
            return;
        }
        MoveFixType moveFixType = this.getMoveFix(MoveFix.movefix.getMode());
        if (moveFixType != null && moveFixType != MoveFixType.NONE) {
            this.setMoveFix(moveFixType, true);
        }
        if (this.resetRotation) {
            this.resetRotation = false;
        }
    }

    @EventHandler(priority=200)
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2596<?> class_25962 = event.packet;
        if (class_25962 instanceof class_2708) {
            class_2708 packet = (class_2708)class_25962;
            this.serverYaw = packet.method_11736();
            this.serverPitch = packet.method_11739();
        }
    }

    @EventHandler(priority=-200)
    private void onSendMovementPacketPre(SendMovementPacketEvent.Pre event) {
        if (this.currentRotation != null) {
            this.setClientRotation(this.currentRotation);
            this.setServerRotation(this.currentRotation);
            return;
        }
        if (this.resetRotation) {
            Rotation serverRot = new Rotation(this.serverYaw, this.serverPitch);
            Rotation clientRot = new Rotation(ClientMain.mc.field_1724.method_36454(), ClientMain.mc.field_1724.method_36455());
            if (Rotation.getTotalDifference(serverRot, clientRot) > 1.0f) {
                Rotation fixedRot = Rotation.fixRots(clientRot, serverRot);
                this.setClientRotation(fixedRot);
                this.setServerRotation(fixedRot);
            } else {
                this.resetRotation = false;
            }
        }
    }

    @EventHandler(priority=200)
    private void onSendMovementPacketPost(SendMovementPacketEvent.Post event) {
        if (this.resetRotation) {
            this.resetClientRotation();
        }
        if (ClientMain.mc.field_1724 == null) {
            return;
        }
        if (this.isRotating()) {
            ClientMain.mc.field_1724.method_5847(this.serverYaw);
            ((ILivingEntity)ClientMain.mc.field_1724).setBodyYaw(this.serverYaw);
        }
    }

    @EventHandler
    private void onMoveFix(MoveFixEvent event) {
        if (this.shouldMoveFix()) {
            event.setYaw(this.serverYaw);
        }
    }

    @EventHandler
    private void onTravelPre(EventPlayerTravel.Pre event) {
        if (this.shouldMoveFix()) {
            this.prevYaw = ClientMain.mc.field_1724.method_36454();
            ClientMain.mc.field_1724.method_36456(this.serverYaw);
        }
    }

    @EventHandler
    private void onTravelPost(EventPlayerTravel.Post event) {
        if (this.shouldMoveFix()) {
            ClientMain.mc.field_1724.method_36456(this.prevYaw);
        }
    }

    @EventHandler(priority=200)
    private void onJumpPre(JumpEvent.Pre event) {
        if (this.shouldMoveFix()) {
            this.prevYaw = ClientMain.mc.field_1724.method_36454();
            ClientMain.mc.field_1724.method_36456(this.serverYaw);
        }
    }

    @EventHandler(priority=100)
    private void onJumpPost(JumpEvent.Post event) {
        if (this.shouldMoveFix()) {
            ClientMain.mc.field_1724.method_36456(this.prevYaw);
        }
    }

    @EventHandler(priority=9999)
    private void onKeyInput(InputEvent.Pre e) {
        if (this.shouldMoveFix() || e.getMovementForward() == 0.0f && e.getMovementSideways() == 0.0f) {
            float realYaw = ClientMain.mc.field_1724.method_36454();
            float fakeYaw = this.serverYaw;
            double moveX = (double)e.getMovementSideways() * Math.cos(Math.toRadians(realYaw)) - (double)e.getMovementForward() * Math.sin(Math.toRadians(realYaw));
            double moveZ = (double)e.getMovementForward() * Math.cos(Math.toRadians(realYaw)) + (double)e.getMovementSideways() * Math.sin(Math.toRadians(realYaw));
            double minDist = Double.MAX_VALUE;
            double bestForward = 0.0;
            double bestStrafe = 0.0;
            for (double forward = -1.0; forward <= 1.0; forward += 1.0) {
                for (double strafe = -1.0; strafe <= 1.0; strafe += 1.0) {
                    double newMoveZ;
                    double deltaZ;
                    double newMoveX = strafe * Math.cos(Math.toRadians(fakeYaw)) - forward * Math.sin(Math.toRadians(fakeYaw));
                    double deltaX = newMoveX - moveX;
                    double dist = Math.sqrt(deltaX * deltaX + (deltaZ = (newMoveZ = forward * Math.cos(Math.toRadians(fakeYaw)) + strafe * Math.sin(Math.toRadians(fakeYaw))) - moveZ) * deltaZ);
                    if (!(minDist > dist)) continue;
                    minDist = dist;
                    bestForward = forward;
                    bestStrafe = strafe;
                }
            }
            e.setMovementForward(Math.round(bestForward));
            e.setMovementSideways(Math.round(bestStrafe));
            ClientMain.mc.field_1724.field_3913.field_3905 = Math.round(bestForward);
            ClientMain.mc.field_1724.field_3913.field_3907 = Math.round(bestStrafe);
        }
    }

    public static void fixMoveDirection(InputEvent event, float targetYaw) {
        float forwardInput = (event.isPressingForward() ? 1.0f : 0.0f) - (event.isPressingBack() ? 1.0f : 0.0f);
        float sidewaysInput = (event.isPressingLeft() ? 1.0f : 0.0f) - (event.isPressingRight() ? 1.0f : 0.0f);
        float deltaYaw = ClientMain.mc.field_1724.method_36454() - targetYaw;
        float rotatedSideways = sidewaysInput * class_3532.method_15362((float)(deltaYaw * ((float)Math.PI / 180))) - forwardInput * class_3532.method_15374((float)(deltaYaw * ((float)Math.PI / 180)));
        float rotatedForward = forwardInput * class_3532.method_15362((float)(deltaYaw * ((float)Math.PI / 180))) + sidewaysInput * class_3532.method_15374((float)(deltaYaw * ((float)Math.PI / 180)));
        event.setMovementForward(Math.round(rotatedForward));
        event.setMovementSideways(Math.round(rotatedSideways));
        ClientMain.mc.field_1724.field_3913.field_3905 = Math.round(rotatedForward);
        ClientMain.mc.field_1724.field_3913.field_3907 = Math.round(rotatedSideways);
    }

    private boolean shouldMoveFix() {
        return !Float.isNaN(this.serverYaw) && this.moveFixType != MoveFixType.NONE && !ClientMain.mc.field_1724.method_3144() && this.isRotating();
    }

    private boolean shouldMoveFixStrict() {
        return !Float.isNaN(this.serverYaw) && (this.moveFixType == MoveFixType.STRICT || this.moveFixType == MoveFixType.BOTH) && !ClientMain.mc.field_1724.method_3144() && this.isRotating();
    }

    public void faceEntity(class_1297 target, RotationPriority priority) {
        class_243 targetPos = target.method_19538().method_1031(0.0, (double)target.method_17682() / 2.0, 0.0);
        Rotation rotation = Rotation.getRotationTo(ClientMain.mc.field_1724.method_33571(), targetPos);
        this.setRotation(rotation, priority);
    }

    public void faceBlock(class_2338 pos, RotationPriority priority) {
        class_243 blockCenter = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        this.faceVector(blockCenter, priority);
    }

    public void faceVector(class_243 vec, RotationPriority priority) {
        class_243 eyesPos = ClientMain.mc.field_1724.method_33571();
        double dx = vec.field_1352 - eyesPos.field_1352;
        double dy = vec.field_1351 - eyesPos.field_1351;
        double dz = vec.field_1350 - eyesPos.field_1350;
        double distance = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        float pitch = (float)(-Math.toDegrees(Math.atan2(dy, distance)));
        this.setRotation(new Rotation(yaw, pitch), priority);
    }

    private float smoothAngle(float current, float target, float smoothness) {
        float diff = class_3532.method_15393((float)(target - current));
        return current + diff * smoothness;
    }

    public MoveFixType getMoveFix(String str) {
        if (str.equalsIgnoreCase("None")) {
            return MoveFixType.NONE;
        }
        if (str.equalsIgnoreCase("Silent")) {
            return MoveFixType.SILENT;
        }
        if (str.equalsIgnoreCase("Strict")) {
            return MoveFixType.STRICT;
        }
        if (str.equalsIgnoreCase("Both")) {
            return MoveFixType.BOTH;
        }
        return MoveFixType.NONE;
    }

    public static enum RotationPriority {
        NONE(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        HIGHEST(4);

        private final int level;

        private RotationPriority(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static enum MoveFixType {
        NONE,
        SILENT,
        STRICT,
        BOTH;

    }
}

