/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.managers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.api.astral.EventHandler;
import net.fabricmc.fabric.api.astral.events.EventUpdate;
import net.fabricmc.fabric.managers.ModuleManager;
import net.fabricmc.fabric.systems.module.impl.misc.AntiBot;
import net.fabricmc.fabric.utils.player.RaycastUtils;
import net.fabricmc.fabric.utils.world.WorldUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_3966;

public class SocialManager {
    private static final Path settingsPath = Path.of(System.getenv("LOCALAPPDATA"), "Programs", "Common", "friends.json");
    private static final Gson gson = new Gson();
    private static final Map<class_1657, Set<BotFlags>> bots = new ConcurrentHashMap<class_1657, Set<BotFlags>>();
    private static final Set<class_1657> verifiedPlayers = new HashSet<class_1657>();
    private static final Set<UUID> teammates = new HashSet<UUID>();
    private static class_1657 target;

    public static Set<UUID> getFriendsList() {
        HashSet<UUID> friends = new HashSet<UUID>();
        try {
            JsonObject jsonObject;
            String content;
            if (Files.exists(settingsPath, new LinkOption[0]) && !(content = Files.readString(settingsPath)).isEmpty() && (jsonObject = JsonParser.parseString((String)content).getAsJsonObject()).has("friends")) {
                for (JsonElement jsonElement : jsonObject.getAsJsonArray("friends")) {
                    friends.add(UUID.fromString(jsonElement.getAsString()));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return friends;
    }

    public static boolean isFriend(UUID playerUuid) {
        return SocialManager.getFriendsList().contains(playerUuid);
    }

    public static void addFriend(UUID playerUuid) {
        Set<UUID> friends = SocialManager.getFriendsList();
        friends.add(playerUuid);
        SocialManager.saveFriendsList(friends);
    }

    public static void removeFriend(UUID playerUuid) {
        Set<UUID> friends = SocialManager.getFriendsList();
        friends.remove(playerUuid);
        SocialManager.saveFriendsList(friends);
    }

    private static void saveFriendsList(Set<UUID> friends) {
        try {
            String content;
            JsonObject jsonObject;
            if (!Files.exists(settingsPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(settingsPath.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(settingsPath, new LinkOption[0])) {
                Files.createFile(settingsPath, new FileAttribute[0]);
            }
            if (!(jsonObject = (content = Files.readString(settingsPath)).isEmpty() ? new JsonObject() : JsonParser.parseString((String)content).getAsJsonObject()).has("friends")) {
                jsonObject.add("friends", gson.toJsonTree(new HashSet()));
            }
            jsonObject.add("friends", gson.toJsonTree(friends));
            Files.writeString(settingsPath, (CharSequence)gson.toJson((JsonElement)jsonObject), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addBot(class_1657 player) {
        bots.putIfAbsent(player, new HashSet());
    }

    public static void removeBot(class_1657 player) {
        bots.remove(player);
    }

    public static Set<class_1657> getBots() {
        return bots.keySet();
    }

    public static boolean isBot(class_1657 player) {
        return bots.containsKey(player);
    }

    public static void addBotFlag(class_1657 player, BotFlags flag) {
        bots.computeIfPresent(player, (p, flags) -> {
            flags.add(flag);
            return flags;
        });
    }

    private static boolean meetsCriteria(class_1657 player) {
        Set flags = bots.getOrDefault(player, Collections.emptySet());
        return flags.contains((Object)BotFlags.MOVED) && flags.contains((Object)BotFlags.TOUCHED_GROUND) && flags.contains((Object)BotFlags.ROTATED) && flags.contains((Object)BotFlags.PING_ISNT_0) && flags.contains((Object)BotFlags.SWINGED);
    }

    @EventHandler
    public void onUpdate(EventUpdate e) {
        if (ClientMain.mc.field_1687 == null || ClientMain.mc.field_1724 == null) {
            return;
        }
        if (!ModuleManager.INSTANCE.getModuleByClass(AntiBot.class).isEnabled()) {
            return;
        }
        ClientMain.mc.field_1687.method_18456().forEach(player -> {
            if (player == null || player == ClientMain.mc.field_1724) {
                return;
            }
            if (verifiedPlayers.contains(player)) {
                return;
            }
            if (player.field_6235 > 0) {
                SocialManager.addBotFlag((class_1657)player, BotFlags.TOOK_DAMAGE);
            }
            if (player.method_24828()) {
                SocialManager.addBotFlag((class_1657)player, BotFlags.TOUCHED_GROUND);
            } else {
                SocialManager.addBotFlag((class_1657)player, BotFlags.IN_AIR);
            }
            if (player.field_6279 > 0) {
                SocialManager.addBotFlag((class_1657)player, BotFlags.SWINGED);
            }
            if (player.method_23317() != player.field_6014 || player.method_23318() != player.field_6036 || player.method_23321() != player.field_5969) {
                SocialManager.addBotFlag((class_1657)player, BotFlags.MOVED);
            }
            if (player.method_36454() != player.field_5982 || player.method_36455() != player.field_6004) {
                SocialManager.addBotFlag((class_1657)player, BotFlags.ROTATED);
            }
            if (WorldUtils.getEntityPing((class_1657)player) != 0) {
                SocialManager.addBotFlag((class_1657)player, BotFlags.PING_ISNT_0);
            }
            if (SocialManager.meetsCriteria((class_1657)player)) {
                SocialManager.removeBot((class_1657)player);
                verifiedPlayers.add((class_1657)player);
            } else {
                SocialManager.addBot((class_1657)player);
                if (AntiBot.remove.isEnabled()) {
                    ClientMain.mc.field_1687.method_2945(player.method_5628(), class_1297.class_5529.field_26998);
                }
            }
        });
    }

    public static Set<UUID> getTeammates() {
        return teammates;
    }

    public static void addTeammate(UUID playerUuid) {
        teammates.add(playerUuid);
    }

    public static void removeTeammate(UUID playerUuid) {
        teammates.remove(playerUuid);
    }

    public static boolean isTeammate(UUID playerUuid) {
        return teammates.contains(playerUuid);
    }

    public static void clearTeammates() {
        teammates.clear();
    }

    public static class_1657 getTargetPlayer() {
        return target;
    }

    public static void loseTarget() {
        target = null;
    }

    public static class_1657 findAndSetTarget(TargetCriteria ... criteria) {
        List<class_1657> candidates = SocialManager.findAllTargets(criteria);
        target = candidates.isEmpty() ? null : candidates.get(0);
        return target;
    }

    public static List<class_1657> findAllTargets(TargetCriteria ... criteria) {
        if (ClientMain.mc.field_1687 == null || ClientMain.mc.field_1724 == null) {
            return Collections.emptyList();
        }
        return ClientMain.mc.field_1687.method_18456().stream().filter(SocialManager::isValidTarget).filter(player -> SocialManager.matchesAll((class_1657)player, criteria)).sorted(Comparator.comparingDouble(player -> ClientMain.mc.field_1724.method_5858((class_1297)player))).collect(Collectors.toList());
    }

    public static class_1657 findAndSetTargetSorted(TargetSort sort, TargetCriteria ... criteria) {
        List<class_1657> players = SocialManager.findAllTargets(criteria);
        SocialManager.sortPlayers(players, sort);
        target = players.isEmpty() ? null : players.get(0);
        return target;
    }

    public static void sortPlayers(List<class_1657> players, TargetSort sort) {
        players.sort(switch (sort.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Comparator.comparingDouble(p -> ClientMain.mc.field_1724.method_5858((class_1297)p));
            case 1 -> Comparator.comparingDouble(SocialManager::getHealth);
            case 2 -> Comparator.comparingDouble(SocialManager::getHealth).reversed();
            case 3 -> Comparator.comparingInt(p -> {
                class_3966 hit;
                class_239 patt0$temp = ClientMain.mc.field_1765;
                return patt0$temp instanceof class_3966 && (hit = (class_3966)patt0$temp).method_17782() == p ? 0 : 1;
            });
        });
    }

    public static boolean isValidTarget(class_1657 player) {
        if (ClientMain.mc.field_1724 == null || player == null) {
            return false;
        }
        return player != ClientMain.mc.field_1724 && !player.method_31481() && player.method_5805() && !player.method_7325();
    }

    public static float getHealth(class_1657 player) {
        return player.method_6032() + player.method_6067();
    }

    public static boolean matchesAll(class_1657 player, TargetCriteria ... criteria) {
        for (TargetCriteria c : criteria) {
            if (c.matches((class_1297)player)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVisible(class_1297 entity) {
        return ClientMain.mc.field_1724 != null && ClientMain.mc.field_1724.method_6057(entity);
    }

    public static double getDistance(class_1657 player) {
        return ClientMain.mc.field_1724 == null ? Double.MAX_VALUE : ClientMain.mc.field_1724.method_5858((class_1297)player);
    }

    public static boolean isMoving(class_1297 entity) {
        return entity.method_23317() != entity.field_6014 || entity.method_23321() != entity.field_5969;
    }

    static enum BotFlags {
        MOVED,
        ROTATED,
        TOOK_DAMAGE,
        SWINGED,
        TOUCHED_GROUND,
        IN_AIR,
        PING_ISNT_0;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TargetCriteria {
        NOT_SELF{

            @Override
            public boolean matches(class_1297 entity) {
                return entity != ClientMain.mc.field_1724;
            }
        }
        ,
        NOT_FRIEND{

            @Override
            public boolean matches(class_1297 entity) {
                return !SocialManager.isFriend(entity.method_5667());
            }
        }
        ,
        NOT_TEAMMATE{

            @Override
            public boolean matches(class_1297 entity) {
                return !SocialManager.isTeammate(entity.method_5667());
            }
        }
        ,
        VISIBLE{

            @Override
            public boolean matches(class_1297 entity) {
                return SocialManager.isVisible(entity);
            }
        }
        ,
        HITTABLE{

            @Override
            public boolean matches(class_1297 entity) {
                return RaycastUtils.canHitEntity(entity, 4.0, 1.0f);
            }
        }
        ,
        RANGE_30{

            @Override
            public boolean matches(class_1297 entity) {
                return ClientMain.mc.field_1724 != null && ClientMain.mc.field_1724.method_5739(entity) <= 30.0f;
            }
        }
        ,
        RANGE_20{

            @Override
            public boolean matches(class_1297 entity) {
                return ClientMain.mc.field_1724 != null && ClientMain.mc.field_1724.method_5739(entity) <= 20.0f;
            }
        }
        ,
        RANGE_3{

            @Override
            public boolean matches(class_1297 entity) {
                return ClientMain.mc.field_1724 != null && ClientMain.mc.field_1724.method_5858(entity) <= 9.0;
            }
        }
        ,
        MOVING{

            @Override
            public boolean matches(class_1297 entity) {
                return SocialManager.isMoving(entity);
            }
        }
        ,
        PLAYERSONLY{

            @Override
            public boolean matches(class_1297 entity) {
                return entity instanceof class_1657;
            }
        }
        ,
        ANY{

            @Override
            public boolean matches(class_1297 entity) {
                return true;
            }
        };


        public abstract boolean matches(class_1297 var1);
    }

    public static enum TargetSort {
        CLOSEST,
        LOWEST_HEALTH,
        HIGHEST_HEALTH,
        LOOKING_AT;

    }
}

