/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.gui.theme;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.awt.Color;
import net.fabricmc.fabric.systems.config.JsonUtils;
import net.fabricmc.fabric.utils.render.ColorUtil;

public class Theme {
    public static Color WINDOW_COLOR;
    public static Color LEFT_PANEL;
    public static Color ENABLED;
    public static Color HIGHLIGHT_COLOR;
    public static Color SETTINGS_BG;
    public static Color SETTINGS_HEADER;
    public static Color MODULE_ENABLED_BG;
    public static Color MODULE_DISABLED_BG;
    public static Color MODULE_COLOR;
    public static Color MODULE_TEXT;
    public static Color TOGGLE_BUTTON_BG;
    public static Color TOGGLE_BUTTON_FILL;
    public static Color UNFOCUSED_TEXT_COLOR;
    public static Color MODULE_ENABLED_BG_HOVER;
    public static Color MODULE_DISABLED_BG_HOVER;
    public static Color NORMAL_TEXT_COLOR;
    public static Color MODE_SETTING_BG;
    public static Color MODE_SETTING_FILL;
    public static Color SLIDER_SETTING_BG;
    public static Color CONFIG_EDIT_BG;
    public static Color ACCENT_COLOR1;
    public static Color ACCENT_COLOR2;
    public static boolean GLOW_ENABLED;
    public static int redEnable;
    public static int greenEnable;
    public static int blueEnable;
    public static int red1Enable;
    public static int green1Enable;
    public static int blue1Enable;
    public static int checkboxR;
    public static int checkboxG;
    public static int checkboxB;

    public static void loadTheme(String jsonString) {
        try {
            JsonObject json = (JsonObject)JsonUtils.gson.fromJson(jsonString, JsonObject.class);
            if (json == null) {
                return;
            }
            WINDOW_COLOR = Theme.getColor(json, "windowColor");
            LEFT_PANEL = Theme.getColor(json, "leftPanel");
            ENABLED = Theme.getColor(json, "enabled");
            HIGHLIGHT_COLOR = Theme.getColor(json, "highlightColor");
            SETTINGS_BG = Theme.getColor(json, "settingsBg");
            SETTINGS_HEADER = Theme.getColor(json, "settingsHeader");
            MODULE_ENABLED_BG = Theme.getColor(json, "moduleEnabledBg");
            MODULE_DISABLED_BG = Theme.getColor(json, "moduleDisabledBg");
            MODULE_COLOR = Theme.getColor(json, "moduleColor");
            MODULE_TEXT = Theme.getColor(json, "moduleText");
            TOGGLE_BUTTON_BG = Theme.getColor(json, "toggleButtonBg");
            TOGGLE_BUTTON_FILL = Theme.getColor(json, "toggleButtonFill");
            UNFOCUSED_TEXT_COLOR = Theme.getColor(json, "unfocusedTextColor");
            MODULE_ENABLED_BG_HOVER = Theme.getColor(json, "moduleEnabledBgHover");
            MODULE_DISABLED_BG_HOVER = Theme.getColor(json, "moduleDisabledBgHover");
            NORMAL_TEXT_COLOR = Theme.getColor(json, "normalTextColor");
            MODE_SETTING_BG = Theme.getColor(json, "modeSettingBg");
            MODE_SETTING_FILL = Theme.getColor(json, "modeSettingFill");
            SLIDER_SETTING_BG = Theme.getColor(json, "sliderSettingBg");
            CONFIG_EDIT_BG = Theme.getColor(json, "configEditBg");
            ACCENT_COLOR1 = Theme.getColor(json, "accentColor1");
            ACCENT_COLOR2 = Theme.getColor(json, "accentColor2");
            GLOW_ENABLED = Theme.getBoolean(json, "glowEnabled");
            redEnable = Theme.getInt(json, "redEnable");
            greenEnable = Theme.getInt(json, "greenEnable");
            blueEnable = Theme.getInt(json, "blueEnable");
            red1Enable = Theme.getInt(json, "red1Enable");
            green1Enable = Theme.getInt(json, "green1Enable");
            blue1Enable = Theme.getInt(json, "blue1Enable");
            checkboxR = Theme.getInt(json, "checkboxR");
            checkboxG = Theme.getInt(json, "checkboxG");
            checkboxB = Theme.getInt(json, "checkboxB");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Color getColor(JsonObject json, String key) {
        if (json.has(key)) {
            try {
                int[] rgb;
                if (json.get(key).isJsonPrimitive() && json.get(key).getAsJsonPrimitive().isString()) {
                    String value = json.get(key).getAsString();
                    if ("rainbow".equalsIgnoreCase(value)) {
                        return ColorUtil.getRainbow(1);
                    }
                } else if (json.get(key).isJsonArray() && (rgb = (int[])JsonUtils.gson.fromJson(json.get(key), int[].class)).length >= 3) {
                    return new Color(Math.max(0, Math.min(255, rgb[0])), Math.max(0, Math.min(255, rgb[1])), Math.max(0, Math.min(255, rgb[2])));
                }
            }
            catch (JsonSyntaxException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return Color.BLACK;
    }

    private static int getInt(JsonObject json, String key) {
        return json.has(key) ? json.get(key).getAsInt() : 0;
    }

    private static boolean getBoolean(JsonObject json, String key) {
        return json.has(key) && json.get(key).getAsBoolean();
    }
}

