/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.gui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import net.fabricmc.fabric.utils.render.Render2DEngine;
import net.fabricmc.fabric.utils.render.RenderHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class InventoryManagerScreen
extends class_437 {
    private static final Path settingsPath = Path.of(System.getenv("LOCALAPPDATA"), "Programs", "Common", "inventory.json");
    private static final class_1799[] hotbar = new class_1799[9];
    private static final class_1799[] inventory = new class_1799[36];
    private final class_1799[] armor = new class_1799[4];
    private static class_1799 offHand;
    private class_1799 selectedItem = class_1799.field_8037;
    private final class_1799[] selectorItems = new class_1799[]{new class_1799((class_1935)class_1802.field_8102), new class_1799((class_1935)class_1802.field_8399), new class_1799((class_1935)class_1802.field_8187), new class_1799((class_1935)class_1802.field_8705), new class_1799((class_1935)class_1802.field_8634), new class_1799((class_1935)class_1802.field_8463), new class_1799((class_1935)class_1802.field_8574), new class_1799((class_1935)class_1802.field_8176), new class_1799((class_1935)class_1802.field_8069), new class_1799((class_1935)class_1802.field_8802), new class_1799((class_1935)class_1802.field_8556)};

    public InventoryManagerScreen() {
        super((class_2561)class_2561.method_43470((String)"Inventory Manager"));
        this.initializeInventory();
    }

    private void initializeInventory() {
        Arrays.fill(inventory, class_1799.field_8037);
        Arrays.fill(hotbar, class_1799.field_8037);
        offHand = class_1799.field_8037;
    }

    protected void method_25426() {
    }

    public void method_25394(class_332 matrices, int mouseX, int mouseY, float delta) {
        Render2DEngine.drawRoundedBlur(RenderHelper.getMatrixStack(), 0.0f, 0.0f, this.field_22789, this.field_22790, 0.0f, 14.0f, 8.0f, false);
        this.renderSelector(matrices);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.renderInventoryGrid(matrices, hotbar, centerX - 90, centerY + 70);
        this.renderInventoryGrid(matrices, inventory, centerX - 90, centerY - 50);
        this.drawItemStack(matrices, offHand, centerX + 120, centerY - 30);
    }

    private void renderSelector(class_332 matrices) {
        int x = this.field_22789 - 140;
        int y = 20;
        for (class_1799 item : this.selectorItems) {
            Render2DEngine.fill(matrices.method_51448(), x, y, x + 20, y + 20, item.equals(this.selectedItem) ? -7798904 : -5592406);
            this.drawItemStack(matrices, item, x + 1, y + 1);
            y += 26;
        }
    }

    private void renderInventoryGrid(class_332 matrices, class_1799[] slots, int startX, int startY) {
        for (int i = 0; i < slots.length; ++i) {
            int x = startX + i % 9 * 20;
            int y = startY + i / 9 * 20;
            Render2DEngine.fill(matrices.method_51448(), x, y, x + 18, y + 18, -13421773);
            this.drawItemStack(matrices, slots[i], x, y);
        }
    }

    private void drawItemStack(class_332 matrices, class_1799 itemStack, int x, int y) {
        if (!itemStack.method_7960()) {
            matrices.method_51427(itemStack, x, y);
        }
    }

    public void onSlotClick(int slotIndex, boolean isArmorSlot) {
        if (this.selectedItem.method_7960() || this.isItemAlreadyInInventory(this.selectedItem)) {
            return;
        }
        if (isArmorSlot) {
            this.armor[slotIndex] = this.selectedItem;
        } else {
            InventoryManagerScreen.inventory[slotIndex] = this.selectedItem;
        }
        this.selectedItem = class_1799.field_8037;
    }

    private boolean isItemAlreadyInInventory(class_1799 item) {
        return Arrays.stream(inventory).anyMatch(stack -> class_1799.method_7984((class_1799)stack, (class_1799)item));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int selectorX = this.field_22789 - 140;
        for (int i = 0; i < this.selectorItems.length; ++i) {
            int selectorY = 20 + i * 26;
            if (!(mouseX >= (double)selectorX) || !(mouseX <= (double)(selectorX + 20)) || !(mouseY >= (double)selectorY) || !(mouseY <= (double)(selectorY + 20))) continue;
            this.selectedItem = this.selectorItems[i].method_7972();
            return true;
        }
        int invStartX = this.field_22789 / 2 - 90;
        int invStartY = this.field_22790 / 2 - 110;
        for (int i = 0; i < inventory.length; ++i) {
            int x = invStartX + i % 9 * 20;
            int y = invStartY + i / 9 * 20;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 18))) continue;
            this.onSlotClick(i, false);
            return true;
        }
        int armorStartX = this.field_22789 / 2 + 100;
        int armorStartY = this.field_22790 / 2 - 110;
        for (int i = 0; i < this.armor.length; ++i) {
            int x = armorStartX + i * 20;
            int y = armorStartY;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 18))) continue;
            this.onSlotClick(i, true);
            return true;
        }
        int hotbarStartX = this.field_22789 / 2 - 90;
        int hotbarStartY = this.field_22790 / 2 + 70;
        for (int i = 0; i < hotbar.length; ++i) {
            int x = hotbarStartX + i * 20;
            int y = hotbarStartY;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 18))) continue;
            if (!this.selectedItem.method_7960() && !this.isItemAlreadyInInventory(this.selectedItem)) {
                InventoryManagerScreen.hotbar[i] = this.selectedItem.method_7972();
                this.selectedItem = class_1799.field_8037;
            }
            return true;
        }
        int offhandX = this.field_22789 / 2 + 100;
        int offhandY = this.field_22790 / 2 - 40;
        if (mouseX >= (double)offhandX && mouseX <= (double)(offhandX + 18) && mouseY >= (double)offhandY && mouseY <= (double)(offhandY + 18)) {
            if (!this.selectedItem.method_7960() && !this.isItemAlreadyInInventory(this.selectedItem)) {
                offHand = this.selectedItem.method_7972();
                this.selectedItem = class_1799.field_8037;
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.saveInventory();
        super.method_25419();
    }

    private void saveInventory() {
        JsonObject root = new JsonObject();
        root.add("hotbar", (JsonElement)this.serializeItemArray(hotbar));
        root.add("inventory", (JsonElement)this.serializeItemArray(inventory));
        root.add("offHand", (JsonElement)this.serializeItem(offHand));
        try {
            Files.createDirectories(settingsPath.getParent(), new FileAttribute[0]);
            Files.writeString(settingsPath, (CharSequence)root.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JsonArray serializeItemArray(class_1799[] items) {
        JsonArray array = new JsonArray();
        for (class_1799 stack : items) {
            array.add((JsonElement)this.serializeItem(stack));
        }
        return array;
    }

    private JsonObject serializeItem(class_1799 stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", stack.method_7909().toString());
        obj.addProperty("count", (Number)stack.method_7947());
        return obj;
    }

    public static void loadInventory() {
        if (!Files.exists(settingsPath, new LinkOption[0])) {
            return;
        }
        try {
            String json = Files.readString(settingsPath);
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            InventoryManagerScreen.deserializeItemArray(root.getAsJsonArray("hotbar"), hotbar);
            InventoryManagerScreen.deserializeItemArray(root.getAsJsonArray("inventory"), inventory);
            offHand = InventoryManagerScreen.deserializeItem(root.getAsJsonObject("offHand"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deserializeItemArray(JsonArray array, class_1799[] items) {
        for (int i = 0; i < array.size(); ++i) {
            items[i] = InventoryManagerScreen.deserializeItem(array.get(i).getAsJsonObject());
        }
    }

    public static class_1799 deserializeItem(JsonObject obj) {
        String id = obj.get("id").getAsString();
        int count = obj.get("count").getAsInt();
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)id));
        if (item == null) {
            throw new IllegalArgumentException("Invalid item id: " + id);
        }
        return new class_1799((class_1935)item, count);
    }
}

