/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.gui.clickgui.component;

import java.util.ArrayList;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.gui.clickgui.GUI;
import net.fabricmc.fabric.gui.clickgui.components.Component;
import net.fabricmc.fabric.gui.theme.Theme;
import net.fabricmc.fabric.utils.render.Render2DEngine;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public abstract class TextComponent
extends Component {
    private String setting;
    private GUI parent;
    private final class_310 mc = class_310.method_1551();
    private String text;
    private boolean focused;
    private float x;
    private float y;
    private float height;

    public TextComponent(GUI parent, String setting) {
        this.parent = parent;
        this.setting = setting;
    }

    public void draw(class_4587 matrices, float x, float y, float height) {
        this.x = x;
        this.y = y;
        this.height = height;
        Render2DEngine.renderRoundedQuad(matrices, x, y, x + (float)this.mc.field_1772.method_1727(this.text) + 5.0f, y + height, 5.0, 20.0, Theme.SETTINGS_HEADER);
        ClientMain.fontRenderer.drawString(matrices, this.mc.field_1772, this.text, x + 2.0f, y + 2.0f, -1);
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        boolean control;
        if (!this.focused) {
            return false;
        }
        boolean bl = class_310.field_1703 ? modifiers == 8 : (control = modifiers == 2);
        if (control && key == 67) {
            this.mc.field_1774.method_1455(this.text);
            return control;
        }
        if (control && key == 88) {
            this.mc.field_1774.method_1455(this.text);
            this.clearSelection();
        }
        if (key == 257 || key == 335) {
            this.focused = false;
        }
        if (control && key == 86) {
            String clipboard = this.mc.field_1774.method_1460();
            this.text = this.text + clipboard;
        }
        if (key == 259) {
            if (this.text.length() <= 0) {
                return control;
            }
            StringBuilder sb = new StringBuilder(this.text);
            sb.deleteCharAt(this.text.length() - 1);
            this.text = sb.toString();
        }
        return control;
    }

    @Override
    public void charTyped(char letter, int modifiers) {
        boolean shift;
        if (!this.focused) {
            return;
        }
        boolean control = class_310.field_1703 ? modifiers == 8 : modifiers == 2;
        boolean bl = shift = modifiers == 1;
        if (!control && this.isValid(letter)) {
            if (shift) {
                letter = Character.valueOf(letter).toString().toUpperCase().charAt(0);
            }
            this.text = this.text + letter;
        }
    }

    @Override
    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.focused = Component.isHovered(this.x, this.y, this.x + (float)this.mc.field_1772.method_1727(this.text) + 5.0f, this.y + this.height, mouseX, mouseY) && button == 0;
        return false;
    }

    public void clearSelection() {
        this.text = "";
    }

    private boolean isValid(char letter) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!\"$%&/()=? _-:.,;+*/#'";
        ArrayList<Character> characters = new ArrayList<Character>();
        for (char ch : chars.toCharArray()) {
            characters.add(Character.valueOf(ch));
        }
        return characters.contains(Character.valueOf(letter));
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public String getText() {
        return this.text;
    }
}

