/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.gui.clickgui.component;

import java.awt.Color;
import net.fabricmc.fabric.ClientMain;
import net.fabricmc.fabric.gui.clickgui.GUI;
import net.fabricmc.fabric.gui.clickgui.component.Component;
import net.fabricmc.fabric.gui.setting.BooleanSetting;
import net.fabricmc.fabric.gui.theme.Theme;
import net.fabricmc.fabric.utils.render.Animation;
import net.fabricmc.fabric.utils.render.Bounds;
import net.fabricmc.fabric.utils.render.Render2DEngine;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public class CheckBox
extends Component {
    private final BooleanSetting setting;
    private final GUI parent;
    private final Animation animation;

    public CheckBox(BooleanSetting setting, GUI parent, float x, float y) {
        super(setting);
        this.setting = setting;
        this.parent = parent;
        this.setPosition(0.0f, 0.0f);
        this.animation = new Animation(0.0f, 100.0f, 1.0f);
    }

    @Override
    public void drawScreen(class_4587 matrices, int mouseX, int mouseY, float delta) {
        float dotXPosition;
        int gap = (int)(ClientMain.fontRenderer.getWidth(this.setting.getName()) / 4.0f);
        if (this.setting.isEnabled()) {
            dotXPosition = this.x + (float)this.parent.x + (float)this.parent.width - 25.0f + 10.0f;
            ClientMain.fontRenderer.drawString(matrices, ClientMain.mc.field_1772, this.setting.getName(), this.x + (float)this.parent.x + 445.0f, this.y + 8.0f, -1);
            Render2DEngine.renderRoundedQuad(matrices, this.x + (float)this.parent.x + (float)this.parent.width - 30.0f + (float)gap, this.y + 2.0f, this.x + (float)this.parent.x + (float)this.parent.width - 10.0f + (float)gap, this.y + 12.0f, 4.0, 20.0, Theme.ENABLED);
        } else {
            dotXPosition = this.x + (float)this.parent.x + (float)this.parent.width - 25.0f;
            ClientMain.fontRenderer.drawString(matrices, ClientMain.mc.field_1772, this.setting.getName(), this.x + (float)this.parent.x + 445.0f, this.y + 8.0f, Theme.SLIDER_SETTING_BG.getRGB());
            Render2DEngine.renderRoundedQuad(matrices, this.x + (float)this.parent.x + (float)this.parent.width - 30.0f + (float)gap, this.y + 2.0f, this.x + (float)this.parent.x + (float)this.parent.width - 10.0f + (float)gap, this.y + 12.0f, 4.0, 20.0, Theme.TOGGLE_BUTTON_BG);
            Render2DEngine.renderRoundedQuad(matrices, this.x + (float)this.parent.x + (float)this.parent.width - 29.0f + (float)gap, this.y + 3.0f, this.x + (float)this.parent.x + (float)this.parent.width - 11.0f + (float)gap, this.y + 11.0f, 3.0, 20.0, Theme.MODE_SETTING_FILL);
        }
        Color dotColor = this.setting.isEnabled() ? Color.white : Theme.TOGGLE_BUTTON_BG;
        Render2DEngine.drawCircle(matrices, (double)(dotXPosition + (float)gap), (double)(this.y + 7.0f), 3.5, 10.0, dotColor);
        if (CheckBox.isHovered(this.x + (float)this.parent.x + 445.0f + (float)gap, this.y + 2.0f, this.x + (float)this.parent.x + (float)this.parent.width - 5.0f + (float)gap, this.y + 22.0f, mouseX, mouseY)) {
            this.renderTooltip(matrices, this.setting.getDescription().toString(), mouseX, mouseY);
        }
    }

    private void renderTooltip(class_4587 matrices, String description, int mouseX, int mouseY) {
        int maxLineLength = 40;
        String[] lines = description.split("(?<=\\G.{" + maxLineLength + "})");
        int tooltipWidth = 0;
        for (String line : lines) {
            int lineWidth = (int)(ClientMain.fontRenderer.getStringWidth(class_2561.method_30163((String)line)) + 6.0f);
            tooltipWidth = Math.max(tooltipWidth, lineWidth);
        }
        int tooltipHeight = lines.length * 12 + 3;
        int tooltipX = mouseX + 10;
        int tooltipY = mouseY - tooltipHeight - 3;
        Render2DEngine.renderRoundedQuad(matrices, tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, 2.0, 10.0, Color.darkGray);
        for (int i = 0; i < lines.length; ++i) {
            ClientMain.fontRenderer.drawString(matrices, ClientMain.mc.field_1772, lines[i], (float)(tooltipX + 3), (float)(tooltipY + 6 + i * 12), Theme.NORMAL_TEXT_COLOR.getRGB());
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        int gap = (int)(ClientMain.fontRenderer.getWidth(this.setting.getName()) / 4.0f);
        if (CheckBox.isHovered(this.x + (float)this.parent.x + (float)this.parent.width - 30.0f + (float)gap, this.y + 2.0f, this.x + (float)this.parent.x + (float)this.parent.width - 10.0f + (float)gap, this.y + 12.0f, mouseX, mouseY)) {
            this.setting.toggle();
        }
    }

    @Override
    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
    }

    public void setY(float y) {
        this.y = y;
    }

    @Override
    public Bounds getBounds() {
        int gap = (int)(ClientMain.fontRenderer.getWidth(this.setting.getName()) / 4.0f);
        float width = this.parent.width - 445;
        float height = 25.0f;
        return new Bounds(this.x + (float)this.parent.x + (float)this.parent.width - 30.0f + (float)gap, this.y + 2.0f, width, height);
    }
}

