/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.module.modules.donut;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.PrintStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_746;
import skid.krypton.event.EventListener;
import skid.krypton.event.events.TickEvent;
import skid.krypton.module.Category;
import skid.krypton.module.Module;
import skid.krypton.module.setting.BooleanSetting;
import skid.krypton.module.setting.ItemSetting;
import skid.krypton.module.setting.ModeSetting;
import skid.krypton.module.setting.NumberSetting;
import skid.krypton.module.setting.Setting;
import skid.krypton.module.setting.StringSetting;
import skid.krypton.utils.EncryptedString;

public final class AuctionSniper
extends Module {
    private final ItemSetting snipingItem = new ItemSetting(EncryptedString.of("Sniping Item"), class_1802.field_8162);
    private final StringSetting price = new StringSetting(EncryptedString.of("Price"), "1k");
    private final ModeSetting<Mode> mode = new ModeSetting<Mode>(EncryptedString.of("Mode"), Mode.MANUAL, Mode.class).setDescription(EncryptedString.of("Manual is faster but api doesnt require auction gui opened all the time"));
    private final StringSetting apiKey = new StringSetting(EncryptedString.of("Api Key"), "").setDescription(EncryptedString.of("You can get it by typing /api in chat"));
    private final NumberSetting refreshDelay = new NumberSetting(EncryptedString.of("Refresh Delay"), 0.0, 100.0, 2.0, 1.0);
    private final NumberSetting buyDelay = new NumberSetting(EncryptedString.of("Buy Delay"), 0.0, 100.0, 2.0, 1.0);
    private final NumberSetting apiRefreshRate = new NumberSetting(EncryptedString.of("API Refresh Rate"), 10.0, 5000.0, 250.0, 10.0).getValue(EncryptedString.of("How often to query the API (in milliseconds)"));
    private final BooleanSetting showApiNotifications = new BooleanSetting(EncryptedString.of("Show API Notifications"), true).setDescription(EncryptedString.of("Show chat notifications for API actions"));
    private int delayCounter;
    private boolean isProcessing;
    private final HttpClient httpClient;
    private final Gson gson;
    private long lastApiCallTimestamp = 0L;
    private final Map<String, Double> snipingItems = new HashMap<String, Double>();
    private boolean isApiQueryInProgress = false;
    private boolean isAuctionSniping = false;
    private int auctionPageCounter = -1;
    private String currentSellerName = "";

    public AuctionSniper() {
        super(EncryptedString.of("Auction Sniper"), EncryptedString.of("Snipes items on auction house for cheap"), -1, Category.DONUT);
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        this.gson = new Gson();
        Setting[] settingArray = new Setting[]{this.snipingItem, this.price, this.mode, this.apiKey, this.refreshDelay, this.buyDelay, this.apiRefreshRate, this.showApiNotifications};
        this.addSettings(settingArray);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        double d = this.parsePrice(this.price.getValue());
        if (d == -1.0) {
            if (this.mc.field_1724 != null) {
                class_746 clientPlayerEntity = this.mc.field_1724;
                clientPlayerEntity.method_7353(class_2561.method_30163((String)"Invalid Price"), true);
            }
            this.toggle();
            return;
        }
        if (this.snipingItem.getItem() != class_1802.field_8162) {
            Map<String, Double> map = this.snipingItems;
            map.put(this.snipingItem.getItem().toString(), d);
        }
        this.lastApiCallTimestamp = 0L;
        this.isApiQueryInProgress = false;
        this.isAuctionSniping = false;
        this.currentSellerName = "";
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.isAuctionSniping = false;
    }

    @EventListener
    public void onTick(TickEvent tickEvent) {
        block10: {
            block9: {
                if (this.mc.field_1724 == null) {
                    return;
                }
                if (this.delayCounter > 0) {
                    --this.delayCounter;
                    return;
                }
                if (this.mode.isMode(Mode.API)) {
                    this.handleApiMode();
                    return;
                }
                if (!this.mode.isMode(Mode.MANUAL)) break block9;
                class_1703 screenHandler = this.mc.field_1724.field_7512;
                if (!(this.mc.field_1724.field_7512 instanceof class_1707)) break block10;
                if (((class_1707)screenHandler).method_17388() == 6) {
                    this.processSixRowAuction((class_1707)screenHandler);
                } else if (((class_1707)screenHandler).method_17388() == 3) {
                    this.processThreeRowAuction((class_1707)screenHandler);
                }
            }
            return;
        }
        String[] stringArray = this.snipingItem.getItem().method_7876().split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        String string3 = Arrays.stream(string2.replace("_", " ").split(" ")).map(string -> string.substring(0, 1).toUpperCase() + string.substring(1)).collect(Collectors.joining(" "));
        this.mc.method_1562().method_45730("ah " + string3);
        this.delayCounter = 20;
    }

    private void handleApiMode() {
        block10: {
            block12: {
                block8: {
                    block11: {
                        block9: {
                            if (!this.isAuctionSniping) break block8;
                            class_1703 screenHandler = this.mc.field_1724.field_7512;
                            if (!(this.mc.field_1724.field_7512 instanceof class_1707)) break block9;
                            this.auctionPageCounter = -1;
                            if (((class_1707)screenHandler).method_17388() == 6) {
                                this.processSixRowAuction((class_1707)screenHandler);
                            } else if (((class_1707)screenHandler).method_17388() == 3) {
                                this.processThreeRowAuction((class_1707)screenHandler);
                            }
                            break block10;
                        }
                        if (this.auctionPageCounter != -1) break block11;
                        this.mc.method_1562().method_45730("ah " + this.currentSellerName);
                        this.auctionPageCounter = 0;
                        break block10;
                    }
                    if (this.auctionPageCounter <= 40) break block12;
                    this.isAuctionSniping = false;
                    this.currentSellerName = "";
                    break block10;
                }
                if (this.mc.field_1724.field_7512 instanceof class_1707 && this.mc.field_1755.method_25440().getString().contains("Page")) {
                    this.mc.field_1724.method_7346();
                    this.delayCounter = 20;
                    return;
                }
                if (this.isApiQueryInProgress) {
                    return;
                }
                long l = System.currentTimeMillis();
                long l2 = l - this.lastApiCallTimestamp;
                if (l2 > (long)this.apiRefreshRate.getIntValue()) {
                    this.lastApiCallTimestamp = l;
                    if (this.apiKey.getValue().isEmpty()) {
                        if (this.showApiNotifications.getValue()) {
                            class_746 clientPlayerEntity = this.mc.field_1724;
                            clientPlayerEntity.method_7353(class_2561.method_30163((String)"\u00a7cAPI key is not set. Set it using /api in-game."), false);
                        }
                        return;
                    }
                    this.isApiQueryInProgress = true;
                    this.queryApi().thenAccept(this::processApiResponse);
                }
                return;
            }
            ++this.auctionPageCounter;
        }
    }

    private CompletableFuture<List<?>> queryApi() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String string = "https://api.donutsmp.net/v1/auction/list/1";
                HttpResponse<String> httpResponse = this.httpClient.send(HttpRequest.newBuilder().uri(URI.create(string)).header("Authorization", "Bearer " + this.apiKey.getValue()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{\"sort\": \"recently_listed\"}")).build(), HttpResponse.BodyHandlers.ofString());
                if (httpResponse.statusCode() != 200) {
                    if (this.showApiNotifications.getValue() && this.mc.field_1724 != null) {
                        class_746 clientPlayerEntity = this.mc.field_1724;
                        clientPlayerEntity.method_7353(class_2561.method_30163((String)("\u00a7cAPI Error: " + httpResponse.statusCode())), false);
                    }
                    ArrayList arrayList = new ArrayList();
                    this.isApiQueryInProgress = false;
                    return arrayList;
                }
                Gson gson = this.gson;
                JsonArray jsonArray = ((JsonObject)gson.fromJson(httpResponse.body(), JsonObject.class)).getAsJsonArray("result");
                ArrayList<JsonObject> arrayList = new ArrayList<JsonObject>();
                for (JsonElement jsonElement : jsonArray) {
                    arrayList.add(jsonElement.getAsJsonObject());
                }
                this.isApiQueryInProgress = false;
                return arrayList;
            }
            catch (Throwable _t) {
                _t.printStackTrace(System.err);
                return List.of();
            }
        });
    }

    private void processApiResponse(List list) {
        for (Object e : list) {
            try {
                String string2 = ((JsonObject)e).getAsJsonObject("item").get("id").getAsString();
                long l = ((JsonObject)e).get("price").getAsLong();
                String string3 = ((JsonObject)e).getAsJsonObject("seller").get("name").getAsString();
                for (Map.Entry<String, Double> entry : this.snipingItems.entrySet()) {
                    String string = entry.getKey();
                    double d = entry.getValue();
                    if (!string2.contains(string) || !((double)l <= d)) continue;
                    if (this.showApiNotifications.getValue() && this.mc.field_1724 != null) {
                        class_746 clientPlayerEntity = this.mc.field_1724;
                        clientPlayerEntity.method_7353(class_2561.method_30163((String)("\u00a7aFound " + string2 + " for " + this.formatPrice(l) + " \u00a7r(threshold: " + this.formatPrice(d) + ") \u00a7afrom seller: " + string3)), false);
                    }
                    this.isAuctionSniping = true;
                    this.currentSellerName = string3;
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.showApiNotifications.getValue() || this.mc.field_1724 == null) continue;
                class_746 clientPlayerEntity = this.mc.field_1724;
                clientPlayerEntity.method_7353(class_2561.method_30163((String)("\u00a7cError processing auction: " + exception.getMessage())), false);
            }
        }
    }

    private void processSixRowAuction(class_1707 genericContainerScreenHandler) {
        class_1799 itemStack = genericContainerScreenHandler.method_7611(47).method_7677();
        if (itemStack.method_31574(class_1802.field_8162)) {
            this.delayCounter = 2;
            return;
        }
        for (Object e : itemStack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070)) {
            String string = e.toString();
            if (!string.contains("Recently Listed") || !((class_2561)e).method_10866().toString().contains("white") && !string.contains("white")) continue;
            this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, 47, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
            this.delayCounter = 5;
            return;
        }
        for (int i = 0; i < 44; ++i) {
            class_1799 itemStack2 = genericContainerScreenHandler.method_7611(i).method_7677();
            if (!itemStack2.method_31574(this.snipingItem.getItem()) || !this.isValidAuctionItem(itemStack2)) continue;
            if (this.isProcessing) {
                this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, i, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
                this.isProcessing = false;
                return;
            }
            this.isProcessing = true;
            this.delayCounter = this.buyDelay.getIntValue();
            return;
        }
        if (this.isAuctionSniping) {
            this.isAuctionSniping = false;
            this.currentSellerName = "";
            this.mc.field_1724.method_7346();
        } else {
            this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, 49, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
            this.delayCounter = this.refreshDelay.getIntValue();
        }
    }

    private void processThreeRowAuction(class_1707 genericContainerScreenHandler) {
        if (this.isValidAuctionItem(genericContainerScreenHandler.method_7611(13).method_7677())) {
            this.mc.field_1761.method_2906(this.mc.field_1724.field_7512.field_7763, 15, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
            this.delayCounter = 20;
        }
        if (this.isAuctionSniping) {
            this.isAuctionSniping = false;
            this.currentSellerName = "";
        }
    }

    private double parseTooltipPrice(List list) {
        Matcher matcher;
        block2: {
            if (list == null || list.isEmpty()) {
                return -1.0;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = ((class_2561)iterator.next()).getString();
                if (!string3.matches("(?i).*price\\s*:\\s*\\$.*")) continue;
                String string4 = string3.replaceAll("[,$]", "");
                matcher = Pattern.compile("([\\d]+(?:\\.[\\d]+)?)\\s*([KMB])?", 2).matcher(string4);
                if (!matcher.find()) continue;
                break block2;
            }
            return -1.0;
        }
        String string2 = matcher.group(1);
        String string = matcher.group(2) != null ? matcher.group(2).toUpperCase() : "";
        return this.parsePrice(string2 + string);
    }

    private boolean isValidAuctionItem(class_1799 itemStack) {
        List list = itemStack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        double d = this.parseTooltipPrice(list) / (double)itemStack.method_7947();
        double d2 = this.parsePrice(this.price.getValue());
        if (d2 == -1.0) {
            if (this.mc.field_1724 != null) {
                class_746 clientPlayerEntity = this.mc.field_1724;
                clientPlayerEntity.method_7353(class_2561.method_30163((String)"Invalid Price"), true);
            }
            this.toggle();
            return false;
        }
        if (d == -1.0) {
            if (this.mc.field_1724 != null) {
                class_746 clientPlayerEntity = this.mc.field_1724;
                clientPlayerEntity.method_7353(class_2561.method_30163((String)"Invalid Auction Item Price"), true);
                for (int i = 0; i < list.size() - 1; ++i) {
                    PrintStream printStream = System.out;
                    printStream.println(i + ". " + ((class_2561)list.get(i)).getString());
                }
            }
            this.toggle();
            return false;
        }
        boolean bl = d <= d2;
        return bl;
    }

    private double parsePrice(String string) {
        if (string == null) {
            return -1.0;
        }
        if (string.isEmpty()) {
            return -1.0;
        }
        String string2 = string.trim().toUpperCase();
        double d = 1.0;
        if (string2.endsWith("B")) {
            d = 1.0E9;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (string2.endsWith("M")) {
            d = 1000000.0;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (string2.endsWith("K")) {
            d = 1000.0;
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            return Double.parseDouble(string2) * d;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }

    private String formatPrice(double d) {
        if (d >= 1.0E9) {
            Object[] objectArray = new Object[]{d / 1.0E9};
            return String.format("%.2fB", objectArray);
        }
        if (d >= 1000000.0) {
            Object[] objectArray = new Object[]{d / 1000000.0};
            return String.format("%.2fM", objectArray);
        }
        if (d >= 1000.0) {
            Object[] objectArray = new Object[]{d / 1000.0};
            return String.format("%.2fK", objectArray);
        }
        Object[] objectArray = new Object[]{d};
        return String.format("%.2f", objectArray);
    }

    public static enum Mode {
        API("API", 0),
        MANUAL("MANUAL", 1);


        private Mode(String name, int ordinal) {
        }
    }
}

