/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.manager;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import skid.krypton.Krypton;
import skid.krypton.event.CancellableEvent;
import skid.krypton.event.Event;
import skid.krypton.event.EventListener;
import skid.krypton.event.Listener;
import skid.krypton.module.Module;

public final class EventManager {
    private final Map<Class<?>, List<Listener>> EVENTS = new HashMap();

    public void register(Object o) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = o.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventListener.class) || method.getParameterCount() != 1 || !Event.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            this.addListener(o, method, method.getAnnotation(EventListener.class));
        }
    }

    private void addListener(Object o, Method method, EventListener eventListener) {
        Class<?> key = method.getParameterTypes()[0];
        method.setAccessible(true);
        this.EVENTS.computeIfAbsent(key, p0 -> new CopyOnWriteArrayList()).add(new Listener(o, method, eventListener.priority()));
        this.EVENTS.get(key).sort(Comparator.comparingInt(listener -> listener.getPriority().getValue()));
    }

    public void unregister(Object v12) {
        for (List<Listener> listeners : this.EVENTS.values()) {
            listeners.removeIf(v1 -> v1.getInstance() == v12);
        }
    }

    public void clear() {
        this.EVENTS.clear();
    }

    public void a(Event event) {
        List<Listener> listeners = this.EVENTS.get(event.getClass());
        if (listeners == null) {
            return;
        }
        for (Listener listener : listeners) {
            try {
                Object holder = listener.getInstance();
                if (holder instanceof Module && !((Module)holder).isEnabled() || event.isCancelled() && !(event instanceof CancellableEvent)) continue;
                listener.invoke(event);
            }
            catch (Throwable _t) {
                System.err.println("Error dispatching event " + event.getClass().getSimpleName() + " to " + (listener.getInstance() != null ? listener.getInstance().getClass().getSimpleName() : "unknown"));
                _t.printStackTrace(System.err);
            }
        }
    }

    public static void b(Event evt) {
        if (Krypton.INSTANCE == null || Krypton.INSTANCE.getEventBus() == null) {
            return;
        }
        Krypton.INSTANCE.getEventBus().a(evt);
    }
}

