/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.manager;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import skid.krypton.Krypton;
import skid.krypton.module.Module;
import skid.krypton.module.setting.BindSetting;
import skid.krypton.module.setting.BooleanSetting;
import skid.krypton.module.setting.ItemSetting;
import skid.krypton.module.setting.MinMaxSetting;
import skid.krypton.module.setting.ModeSetting;
import skid.krypton.module.setting.NumberSetting;
import skid.krypton.module.setting.Setting;
import skid.krypton.module.setting.StringSetting;

public final class ConfigManager {
    private JsonObject jsonObject;

    public void loadProfile() {
        try {
            if (this.jsonObject == null) {
                this.jsonObject = new JsonObject();
                return;
            }
            for (Module next : Krypton.INSTANCE.getModuleManager().c()) {
                JsonElement value = this.jsonObject.get(next.getName().toString());
                if (value == null || !value.isJsonObject()) continue;
                JsonObject asJsonObject = value.getAsJsonObject();
                JsonElement value2 = asJsonObject.get("enabled");
                if (value2 != null && value2.isJsonPrimitive() && value2.getAsBoolean()) {
                    next.toggle(true);
                }
                for (Setting next2 : next.getSettings()) {
                    JsonElement value3 = asJsonObject.get(next2.getName().toString());
                    if (value3 == null) continue;
                    this.setValueFromJson(next2, value3, next);
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error loading profile: " + ex.getMessage());
        }
    }

    private void setValueFromJson(Setting setting, JsonElement jsonElement, Module module) {
        try {
            if (setting instanceof BooleanSetting) {
                BooleanSetting booleanSetting = (BooleanSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    booleanSetting.setValue(jsonElement.getAsBoolean());
                }
            } else if (setting instanceof ModeSetting) {
                ModeSetting enumSetting = (ModeSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    int asInt = jsonElement.getAsInt();
                    if (asInt != -1) {
                        enumSetting.setModeIndex(asInt);
                    } else {
                        enumSetting.setModeIndex(enumSetting.getOriginalValue());
                    }
                }
            } else if (setting instanceof NumberSetting) {
                NumberSetting numberSetting = (NumberSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    numberSetting.getValue(jsonElement.getAsDouble());
                }
            } else if (setting instanceof BindSetting) {
                BindSetting bindSetting = (BindSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    int asInt2 = jsonElement.getAsInt();
                    bindSetting.setValue(asInt2);
                    if (bindSetting.isModuleKey()) {
                        module.setKeybind(asInt2);
                    }
                }
            } else if (setting instanceof StringSetting) {
                StringSetting stringSetting = (StringSetting)setting;
                if (jsonElement.isJsonPrimitive()) {
                    stringSetting.setValue(jsonElement.getAsString());
                }
            } else if (setting instanceof MinMaxSetting) {
                JsonObject asJsonObject;
                MinMaxSetting minMaxSetting = (MinMaxSetting)setting;
                if (jsonElement.isJsonObject() && (asJsonObject = jsonElement.getAsJsonObject()).has("min") && asJsonObject.has("max")) {
                    double asDouble = asJsonObject.get("min").getAsDouble();
                    double asDouble2 = asJsonObject.get("max").getAsDouble();
                    minMaxSetting.setCurrentMin(asDouble);
                    minMaxSetting.setCurrentMax(asDouble2);
                }
            } else if (setting instanceof ItemSetting && jsonElement.isJsonPrimitive()) {
                ((ItemSetting)setting).setItem((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)jsonElement.getAsString())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        try {
            this.jsonObject = new JsonObject();
            for (Module module : Krypton.INSTANCE.getModuleManager().c()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("enabled", Boolean.valueOf(module.isEnabled()));
                for (Setting setting : module.getSettings()) {
                    this.save(setting, jsonObject, module);
                }
                this.jsonObject.add(module.getName().toString(), (JsonElement)jsonObject);
            }
        }
        catch (Exception _t) {
            _t.printStackTrace(System.err);
        }
    }

    private void save(Setting setting, JsonObject jsonObject, Module module) {
        try {
            if (setting instanceof BooleanSetting) {
                BooleanSetting booleanSetting = (BooleanSetting)setting;
                jsonObject.addProperty(setting.getName().toString(), Boolean.valueOf(booleanSetting.getValue()));
            } else if (setting instanceof ModeSetting) {
                ModeSetting enumSetting = (ModeSetting)setting;
                jsonObject.addProperty(setting.getName().toString(), (Number)enumSetting.getModeIndex());
            } else if (setting instanceof NumberSetting) {
                NumberSetting numberSetting = (NumberSetting)setting;
                jsonObject.addProperty(setting.getName().toString(), (Number)numberSetting.getValue());
            } else if (setting instanceof BindSetting) {
                BindSetting bindSetting = (BindSetting)setting;
                jsonObject.addProperty(setting.getName().toString(), (Number)bindSetting.getValue());
            } else if (setting instanceof StringSetting) {
                StringSetting stringSetting = (StringSetting)setting;
                jsonObject.addProperty(setting.getName().toString(), stringSetting.getValue());
            } else if (setting instanceof MinMaxSetting) {
                JsonObject jsonObject2 = new JsonObject();
                jsonObject2.addProperty("min", (Number)((MinMaxSetting)setting).getCurrentMin());
                jsonObject2.addProperty("max", (Number)((MinMaxSetting)setting).getCurrentMax());
                jsonObject.add(setting.getName().toString(), (JsonElement)jsonObject2);
            } else if (setting instanceof ItemSetting) {
                ItemSetting itemSetting = (ItemSetting)setting;
                jsonObject.addProperty(setting.getName().toString(), class_7923.field_41178.method_10221((Object)itemSetting.getItem()).toString());
            }
        }
        catch (Exception ex) {
            System.err.println("Error saving setting " + String.valueOf(setting.getName()) + ": " + ex.getMessage());
        }
    }
}

