/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.gui.components;

import java.awt.Color;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import skid.krypton.gui.Component;
import skid.krypton.gui.components.ModuleButton;
import skid.krypton.module.setting.NumberSetting;
import skid.krypton.module.setting.Setting;
import skid.krypton.utils.ColorUtil;
import skid.krypton.utils.MathUtil;
import skid.krypton.utils.RenderUtils;
import skid.krypton.utils.TextRenderer;
import skid.krypton.utils.Utils;

public final class NumberBox
extends Component {
    public boolean dragging;
    public double offsetX;
    public double lerpedOffsetX = 0.0;
    private float hoverAnimation = 0.0f;
    private final NumberSetting setting;
    public Color currentColor1;
    private Color currentAlpha;
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color TRACK_BG_COLOR = new Color(60, 60, 65);
    private final float TRACK_HEIGHT = 4.0f;
    private final float TRACK_RADIUS = 2.0f;
    private final float ANIMATION_SPEED = 0.25f;

    public NumberBox(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (NumberSetting)setting;
    }

    @Override
    public void onUpdate() {
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        this.currentColor1 = this.currentColor1 == null ? new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), 0) : new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), this.currentColor1.getAlpha());
        if (this.currentColor1.getAlpha() != 255) {
            this.currentColor1 = ColorUtil.a(0.05f, 255, this.currentColor1);
        }
        super.onUpdate();
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        this.updateAnimations(n, n2, n3);
        this.offsetX = (this.setting.getValue() - this.setting.getMin()) / (this.setting.getMax() - this.setting.getMin()) * (double)this.parentWidth();
        this.lerpedOffsetX = MathUtil.approachValue((float)(0.5 * (double)n3), this.lerpedOffsetX, this.offsetX);
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(this.HOVER_COLOR.getRed(), this.HOVER_COLOR.getGreen(), this.HOVER_COLOR.getBlue(), (int)((float)this.HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        int n4 = this.parentY() + this.offset + this.parentOffset() + 25;
        int n5 = this.parentX() + 5;
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.TRACK_BG_COLOR, n5, n4, n5 + (this.parentWidth() - 10), (float)n4 + 4.0f, 2.0, 2.0, 2.0, 2.0, 50.0);
        if (this.lerpedOffsetX > 2.5) {
            RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.currentColor1, n5, n4, (double)n5 + Math.max(this.lerpedOffsetX - 5.0, 0.0), (float)n4 + 4.0f, 2.0, 2.0, 2.0, 2.0, 50.0);
        }
        String displayValue = this.getDisplayValue();
        TextRenderer.drawString(this.setting.getName(), drawContext, this.parentX() + 5, this.parentY() + this.parentOffset() + this.offset + 9, this.TEXT_COLOR.getRGB());
        TextRenderer.drawString(displayValue, drawContext, this.parentX() + this.parentWidth() - TextRenderer.getWidth(displayValue) - 5, this.parentY() + this.parentOffset() + this.offset + 9, this.currentColor1.getRGB());
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n4, 0.25, n3 * 0.05f);
    }

    private String getDisplayValue() {
        double a = this.setting.getValue();
        double c = this.setting.getFormat();
        if (c == 0.1) {
            return String.format("%.1f", a);
        }
        if (c == 0.01) {
            return String.format("%.2f", a);
        }
        if (c == 0.001) {
            return String.format("%.3f", a);
        }
        if (c == 1.0E-4) {
            return String.format("%.4f", a);
        }
        if (c >= 1.0) {
            return String.format("%.0f", a);
        }
        return String.valueOf(a);
    }

    @Override
    public void onGuiClose() {
        this.currentColor1 = null;
        this.hoverAnimation = 0.0f;
        super.onGuiClose();
    }

    private void slide(double n) {
        this.setting.getValue(MathUtil.roundToNearest(class_3532.method_15350((double)((n - (double)(this.parentX() + 5)) / (double)(this.parentWidth() - 10)), (double)0.0, (double)1.0) * (this.setting.getMax() - this.setting.getMin()) + this.setting.getMin(), this.setting.getFormat()));
    }

    @Override
    public void keyPressed(int n, int n2, int n3) {
        if (this.mouseOver && this.parent.extended && n == 259) {
            this.setting.getValue(this.setting.getDefaultValue());
        }
        super.keyPressed(n, n2, n3);
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (this.isHovered(n, n2) && n3 == 0) {
            this.dragging = true;
            this.slide(n);
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void mouseReleased(double n, double n2, int n3) {
        if (this.dragging && n3 == 0) {
            this.dragging = false;
        }
        super.mouseReleased(n, n2, n3);
    }

    @Override
    public void mouseDragged(double n, double n2, int n3, double n4, double n5) {
        if (this.dragging) {
            this.slide(n);
        }
        super.mouseDragged(n, n2, n3, n4, n5);
    }
}

