/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.gui.components;

import java.awt.Color;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_332;
import net.minecraft.class_437;
import skid.krypton.gui.Component;
import skid.krypton.gui.components.ItemFilter;
import skid.krypton.gui.components.ModuleButton;
import skid.krypton.module.setting.ItemSetting;
import skid.krypton.module.setting.Setting;
import skid.krypton.utils.ColorUtil;
import skid.krypton.utils.MathUtil;
import skid.krypton.utils.RenderUtils;
import skid.krypton.utils.TextRenderer;
import skid.krypton.utils.Utils;

public final class ItemBox
extends Component {
    private final ItemSetting setting;
    private float hoverAnimation = 0.0f;
    private Color currentColor;
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color ITEM_BG = new Color(30, 30, 35);
    private final Color ITEM_BORDER = new Color(60, 60, 65);
    private final float CORNER_RADIUS = 4.0f;
    private final float HOVER_ANIMATION_SPEED = 0.25f;

    public ItemBox(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (ItemSetting)setting;
    }

    @Override
    public void onUpdate() {
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        this.currentColor = this.currentColor == null ? new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), 0) : new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), this.currentColor.getAlpha());
        if (this.currentColor.getAlpha() != 255) {
            this.currentColor = ColorUtil.a(0.05f, 255, this.currentColor);
        }
        super.onUpdate();
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        this.updateAnimations(n, n2, n3);
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(this.HOVER_COLOR.getRed(), this.HOVER_COLOR.getGreen(), this.HOVER_COLOR.getBlue(), (int)((float)this.HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        int n4 = this.parentX() + 5;
        int n5 = this.parentY() + this.parentOffset() + this.offset + this.parentHeight() / 2;
        TextRenderer.drawString(String.valueOf(this.setting.getName()), drawContext, n4, n5 - 8, this.TEXT_COLOR.getRGB());
        int n6 = n4 + TextRenderer.getWidth(String.valueOf(this.setting.getName()) + ": ") + 5;
        int n7 = n5 - 11;
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.ITEM_BORDER, n6, n7, n6 + 22, n7 + 22, 4.0, 4.0, 4.0, 4.0, 50.0);
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.ITEM_BG, n6 + 1, n7 + 1, n6 + 22 - 1, n7 + 22 - 1, 3.5, 3.5, 3.5, 3.5, 50.0);
        class_1792 a = this.setting.getItem();
        if (a != null && a != class_1802.field_8162) {
            drawContext.method_51427(new class_1799((class_1935)a), n6 + 3, n7 + 3);
        } else {
            TextRenderer.drawCenteredString("?", drawContext, n6 + 11 - 1, n7 + 4, new Color(150, 150, 150, 200).getRGB());
        }
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n4, 0.25, n3 * 0.05f);
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (this.isHovered(n, n2) && n3 == 0) {
            this.mc.method_1507((class_437)new ItemFilter(this, this.setting));
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void onGuiClose() {
        this.currentColor = null;
        this.hoverAnimation = 0.0f;
        super.onGuiClose();
    }
}

