/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.gui.components;

import java.awt.Color;
import net.minecraft.class_332;
import skid.krypton.gui.Component;
import skid.krypton.gui.components.ModuleButton;
import skid.krypton.module.setting.BooleanSetting;
import skid.krypton.module.setting.Setting;
import skid.krypton.utils.MathUtil;
import skid.krypton.utils.RenderUtils;
import skid.krypton.utils.TextRenderer;
import skid.krypton.utils.Utils;

public final class Checkbox
extends Component {
    private final BooleanSetting setting;
    private float hoverAnimation = 0.0f;
    private float enabledAnimation = 0.0f;
    private final float CORNER_RADIUS = 3.0f;
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private final Color HOVER_COLOR = new Color(255, 255, 255, 20);
    private final Color BOX_BORDER = new Color(100, 100, 110);
    private final Color BOX_BG = new Color(40, 40, 45);
    private final int BOX_SIZE = 13;
    private final float HOVER_ANIMATION_SPEED = 0.005f;
    private final float TOGGLE_ANIMATION_SPEED = 0.002f;

    public Checkbox(ModuleButton moduleButton, Setting setting, int n) {
        super(moduleButton, setting, n);
        this.setting = (BooleanSetting)setting;
        float enabledAnimation = this.setting.getValue() ? 1.0f : 0.0f;
        this.enabledAnimation = enabledAnimation;
    }

    @Override
    public void render(class_332 drawContext, int n, int n2, float n3) {
        super.render(drawContext, n, n2, n3);
        this.updateAnimations(n, n2, n3);
        if (!this.parent.parent.dragging) {
            drawContext.method_25294(this.parentX(), this.parentY() + this.parentOffset() + this.offset, this.parentX() + this.parentWidth(), this.parentY() + this.parentOffset() + this.offset + this.parentHeight(), new Color(this.HOVER_COLOR.getRed(), this.HOVER_COLOR.getGreen(), this.HOVER_COLOR.getBlue(), (int)((float)this.HOVER_COLOR.getAlpha() * this.hoverAnimation)).getRGB());
        }
        TextRenderer.drawString(this.setting.getName(), drawContext, this.parentX() + 27, this.parentY() + this.parentOffset() + this.offset + this.parentHeight() / 2 - 6, this.TEXT_COLOR.getRGB());
        this.renderModernCheckbox(drawContext);
    }

    private void updateAnimations(int n, int n2, float n3) {
        float n4 = n3 * 0.05f;
        float n5 = this.isHovered(n, n2) && !this.parent.parent.dragging ? 1.0f : 0.0f;
        this.hoverAnimation = (float)MathUtil.exponentialInterpolate(this.hoverAnimation, n5, 0.005f, n4);
        float n6 = this.setting.getValue() ? 1.0f : 0.0f;
        this.enabledAnimation = (float)MathUtil.exponentialInterpolate(this.enabledAnimation, n6, 0.002f, n4);
        this.enabledAnimation = (float)MathUtil.clampValue(this.enabledAnimation, 0.0, 1.0);
    }

    private void renderModernCheckbox(class_332 drawContext) {
        int n = this.parentX() + 8;
        int n2 = this.parentY() + this.parentOffset() + this.offset + this.parentHeight() / 2 - 6;
        Color mainColor = Utils.getMainColor(255, this.parent.settings.indexOf(this));
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.BOX_BORDER, n, n2, n + 13, n2 + 13, 3.0, 3.0, 3.0, 3.0, 50.0);
        RenderUtils.renderRoundedQuad(drawContext.method_51448(), this.BOX_BG, n + 1, n2 + 1, n + 13 - 1, n2 + 13 - 1, 2.5, 2.5, 2.5, 2.5, 50.0);
        if (this.enabledAnimation > 0.01f) {
            Color color = new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), (int)(255.0f * this.enabledAnimation));
            float n3 = (float)(n + 2) + 9.0f * (1.0f - this.enabledAnimation) / 2.0f;
            float n4 = (float)(n2 + 2) + 9.0f * (1.0f - this.enabledAnimation) / 2.0f;
            RenderUtils.renderRoundedQuad(drawContext.method_51448(), color, n3, n4, n3 + 9.0f * this.enabledAnimation, n4 + 9.0f * this.enabledAnimation, 1.5, 1.5, 1.5, 1.5, 50.0);
            if (this.enabledAnimation > 0.7f) {
                RenderUtils.renderRoundedQuad(drawContext.method_51448(), new Color(mainColor.getRed(), mainColor.getGreen(), mainColor.getBlue(), (int)(40.0f * ((this.enabledAnimation - 0.7f) * 3.33f))), n - 1, n2 - 1, n + 13 + 1, n2 + 13 + 1, 3.5, 3.5, 3.5, 3.5, 50.0);
            }
        }
    }

    @Override
    public void keyPressed(int n, int n2, int n3) {
        if (this.mouseOver && this.parent.extended && n == 259) {
            this.setting.setValue(this.setting.getDefaultValue());
        }
        super.keyPressed(n, n2, n3);
    }

    @Override
    public void mouseClicked(double n, double n2, int n3) {
        if (this.isHovered(n, n2) && n3 == 0) {
            this.setting.toggle();
        }
        super.mouseClicked(n, n2, n3);
    }

    @Override
    public void onGuiClose() {
        super.onGuiClose();
        this.hoverAnimation = 0.0f;
        float enabledAnimation = this.setting.getValue() ? 1.0f : 0.0f;
        this.enabledAnimation = enabledAnimation;
    }
}

