/*
 * Decompiled with CFR 0.152.
 */
package skid.krypton.font;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Font;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import skid.krypton.font.GlyphPage;
import skid.krypton.utils.EncryptedString;

public final class GlyphPageFontRenderer {
    public Random random = new Random();
    private float posX;
    private float posY;
    private final int[] colorCode = new int[32];
    private boolean isBold;
    private boolean isItalic;
    private boolean isUnderline;
    private boolean isStrikethrough;
    private final GlyphPage regular;
    private final GlyphPage bold;
    private final GlyphPage italic;
    private final GlyphPage boldItalic;

    public GlyphPageFontRenderer(GlyphPage regular, GlyphPage bold, GlyphPage italic, GlyphPage boldItalic) {
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
        for (int n = 0; n < 32; ++n) {
            int j = (n >> 3 & 1) * 85;
            int k = (n >> 2 & 1) * 170 + j;
            int l = (n >> 1 & 1) * 170 + j;
            int m = (n & 1) * 170 + j;
            if (n == 6) {
                k += 85;
            }
            if (n >= 16) {
                k /= 4;
                l /= 4;
                m /= 4;
            }
            this.colorCode[n] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | m & 0xFF;
        }
    }

    public static GlyphPageFontRenderer a(CharSequence font, int size, boolean bold, boolean italic, boolean boldItalic) {
        char[] chars = new char[256];
        for (int i = 0; i < 256; ++i) {
            chars[i] = (char)i;
        }
        GlyphPage regularPage = new GlyphPage(new Font(font.toString(), 0, size), true, true);
        regularPage.generate(chars);
        regularPage.setup();
        GlyphPage boldPage = regularPage;
        GlyphPage italicPage = regularPage;
        GlyphPage boldItalicPage = regularPage;
        if (bold) {
            boldPage = new GlyphPage(new Font(font.toString(), 1, size), true, true);
            boldPage.generate(chars);
            boldPage.setup();
        }
        if (italic) {
            italicPage = new GlyphPage(new Font(font.toString(), 2, size), true, true);
            italicPage.generate(chars);
            italicPage.setup();
        }
        if (boldItalic) {
            boldItalicPage = new GlyphPage(new Font(font.toString(), 3, size), true, true);
            boldItalicPage.generate(chars);
            boldItalicPage.setup();
        }
        return new GlyphPageFontRenderer(regularPage, boldPage, italicPage, boldItalicPage);
    }

    public static GlyphPageFontRenderer init(CharSequence id, int size, boolean bold, boolean italic, boolean boldItalic) {
        try {
            char[] chars = new char[256];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (char)i;
            }
            Font font = Font.createFont(0, Objects.requireNonNull(GlyphPageFontRenderer.class.getResourceAsStream(id.toString()))).deriveFont(0, size);
            GlyphPage regularPage = new GlyphPage(font, true, true);
            regularPage.generate(chars);
            regularPage.setup();
            GlyphPage boldPage = regularPage;
            GlyphPage italicPage = regularPage;
            GlyphPage boldItalicPage = regularPage;
            if (bold) {
                boldPage = new GlyphPage(Font.createFont(0, Objects.requireNonNull(GlyphPageFontRenderer.class.getResourceAsStream(id.toString()))).deriveFont(1, size), true, true);
                boldPage.generate(chars);
                boldPage.setup();
            }
            if (italic) {
                italicPage = new GlyphPage(Font.createFont(0, Objects.requireNonNull(GlyphPageFontRenderer.class.getResourceAsStream(id.toString()))).deriveFont(2, size), true, true);
                italicPage.generate(chars);
                italicPage.setup();
            }
            if (boldItalic) {
                boldItalicPage = new GlyphPage(Font.createFont(0, Objects.requireNonNull(GlyphPageFontRenderer.class.getResourceAsStream(id.toString()))).deriveFont(3, size), true, true);
                boldItalicPage.generate(chars);
                boldItalicPage.setup();
            }
            return new GlyphPageFontRenderer(regularPage, boldPage, italicPage, boldItalicPage);
        }
        catch (Throwable _t) {
            _t.printStackTrace(System.err);
            return null;
        }
    }

    public int drawStringWithShadow(class_4587 matrices, CharSequence text, float x, float y, int color) {
        return this.drawString(matrices, text, x, y, color, true);
    }

    public int drawStringWithShadow(class_4587 matrices, CharSequence text, double x, double y, int color) {
        return this.drawString(matrices, text, (float)x, (float)y, color, true);
    }

    public int drawString(class_4587 matrices, CharSequence text, float x, float y, int color) {
        return this.drawString(matrices, text, x, y, color, false);
    }

    public int drawString(class_4587 matrices, CharSequence text, double x, double y, int color) {
        return this.drawString(matrices, text, (float)x, (float)y, color, false);
    }

    public int drawCenteredString(class_4587 matrices, CharSequence text, double x, double y, float scale, int color) {
        return this.drawString(matrices, text, (float)x - (float)(this.getStringWidth(text) / 2), (float)y, scale, color, false);
    }

    public int drawCenteredString(class_4587 matrices, CharSequence text, double x, double y, int color) {
        return this.drawString(matrices, text, (float)x - (float)(this.getStringWidth(text) / 2), (float)y, color, false);
    }

    public int drawCenteredStringWithShadow(class_4587 matrices, CharSequence text, double x, double y, int color) {
        return this.drawString(matrices, text, (float)x - (float)(this.getStringWidth(text) / 2), (float)y, color, true);
    }

    public int drawString(class_4587 matrices, CharSequence text, float x, float y, float scale, int color, boolean shadow) {
        this.resetStyles();
        return shadow ? Math.max(this.renderString(matrices, text, x + 1.0f, y + 1.0f, scale, color, true), this.renderString(matrices, text, x, y, scale, color, false)) : this.renderString(matrices, text, x, y, scale, color, false);
    }

    public int drawString(class_4587 matrices, CharSequence text, float x, float y, int color, boolean shadow) {
        this.resetStyles();
        return shadow ? Math.max(this.renderString(matrices, text, x + 1.0f, y + 1.0f, color, true), this.renderString(matrices, text, x, y, color, false)) : this.renderString(matrices, text, x, y, color, false);
    }

    private int renderString(class_4587 matrices, CharSequence text, float x, float y, int color, boolean shadow) {
        if (text == null) {
            return 0;
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (shadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.posX = x * 2.0f;
        this.posY = y * 2.0f;
        this.a(matrices, text, shadow, color);
        return (int)(this.posX / 4.0f);
    }

    private int renderString(class_4587 matrices, CharSequence text, float x, float y, float scale, int color, boolean shadow) {
        if (text == null) {
            return 0;
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (shadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.posX = x * 2.0f;
        this.posY = y * 2.0f;
        this.renderStringAtPos(matrices, text, scale, shadow, color);
        return (int)(this.posX / 4.0f);
    }

    private void a(class_4587 matrices, CharSequence text, boolean shadow, int color) {
        GlyphPage page = this.getPage();
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        matrices.method_22903();
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        page.bind();
        GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\ufffd' && i + 1 < text.length()) {
                int index = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(text.charAt(i + 1)));
                if (index < 16) {
                    this.isBold = false;
                    this.isStrikethrough = false;
                    this.isUnderline = false;
                    this.isItalic = false;
                    if (index < 0) {
                        index = 15;
                    }
                    if (shadow) {
                        index += 16;
                    }
                    int j1 = this.colorCode[index];
                    g = (float)(j1 >> 16 & 0xFF) / 255.0f;
                    h = (float)(j1 >> 8 & 0xFF) / 255.0f;
                    k = (float)(j1 & 0xFF) / 255.0f;
                } else if (index != 16) {
                    if (index == 17) {
                        this.isBold = true;
                    } else if (index == 18) {
                        this.isStrikethrough = true;
                    } else if (index == 19) {
                        this.isUnderline = true;
                    } else if (index == 20) {
                        this.isItalic = true;
                    } else {
                        this.isBold = false;
                        this.isStrikethrough = false;
                        this.isUnderline = false;
                        this.isItalic = false;
                    }
                }
                ++i;
                continue;
            }
            page = this.getPage();
            page.bind();
            this.doDraw(page.drawChar(matrices, ch, this.posX, this.posY, g, k, h, (float)(color >> 24 & 0xFF) / 255.0f), page);
        }
        page.unbind();
        matrices.method_22909();
    }

    private void renderStringAtPos(class_4587 matrices, CharSequence text, float scale, boolean shadow, int color) {
        GlyphPage page = this.getPage();
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale);
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        page.bind();
        GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\ufffd' && i + 1 < text.length()) {
                int index = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(text.charAt(i + 1)));
                if (index < 16) {
                    this.isBold = false;
                    this.isStrikethrough = false;
                    this.isUnderline = false;
                    this.isItalic = false;
                    if (index < 0) {
                        index = 15;
                    }
                    if (shadow) {
                        index += 16;
                    }
                    int j1 = this.colorCode[index];
                    g = (float)(j1 >> 16 & 0xFF) / 255.0f;
                    h = (float)(j1 >> 8 & 0xFF) / 255.0f;
                    k = (float)(j1 & 0xFF) / 255.0f;
                } else if (index != 16) {
                    if (index == 17) {
                        this.isBold = true;
                    } else if (index == 18) {
                        this.isStrikethrough = true;
                    } else if (index == 19) {
                        this.isUnderline = true;
                    } else if (index == 20) {
                        this.isItalic = true;
                    } else {
                        this.isBold = false;
                        this.isStrikethrough = false;
                        this.isUnderline = false;
                        this.isItalic = false;
                    }
                }
                ++i;
                continue;
            }
            page = this.getPage();
            page.bind();
            this.doDraw(page.drawChar(matrices, ch, this.posX, this.posY, g, k, h, (float)(color >> 24 & 0xFF) / 255.0f), page);
        }
        page.unbind();
        matrices.method_22909();
    }

    private void doDraw(float f, GlyphPage page) {
        class_287 buffer;
        if (this.isStrikethrough) {
            buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            buffer.method_22912(this.posX, this.posY + (float)(page.getMaxHeight() / 2), 0.0f);
            buffer.method_22912(this.posX + f, this.posY + (float)(page.getMaxHeight() / 2), 0.0f);
            buffer.method_22912(this.posX + f, this.posY + (float)(page.getMaxHeight() / 2) - 1.0f, 0.0f);
            buffer.method_22912(this.posX, this.posY + (float)(page.getMaxHeight() / 2) - 1.0f, 0.0f);
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        if (this.isUnderline) {
            buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            int l = this.isUnderline ? -1 : 0;
            buffer.method_22912(this.posX + (float)l, this.posY + (float)page.getMaxHeight(), 0.0f);
            buffer.method_22912(this.posX + f, this.posY + (float)page.getMaxHeight(), 0.0f);
            buffer.method_22912(this.posX + f, this.posY + (float)page.getMaxHeight() - 1.0f, 0.0f);
            buffer.method_22912(this.posX + (float)l, this.posY + (float)page.getMaxHeight() - 1.0f, 0.0f);
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        this.posX += f;
    }

    private GlyphPage getPage() {
        if (this.isBold && this.isItalic) {
            return this.boldItalic;
        }
        if (this.isBold) {
            return this.bold;
        }
        if (this.isItalic) {
            return this.italic;
        }
        return this.regular;
    }

    private void resetStyles() {
        this.isBold = false;
        this.isItalic = false;
        this.isUnderline = false;
        this.isStrikethrough = false;
    }

    public int getHeight() {
        return this.regular.getMaxHeight() / 2;
    }

    public int getStringWidth(CharSequence text) {
        if (text == null) {
            return 0;
        }
        int width = 0;
        boolean on = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\ufffd') {
                on = true;
                continue;
            }
            if (on && ch >= '0' && ch <= 'r') {
                int index = "0123456789abcdefklmnor".indexOf(ch);
                if (index < 16) {
                    this.isBold = false;
                    this.isItalic = false;
                } else if (index == 17) {
                    this.isBold = true;
                } else if (index == 20) {
                    this.isItalic = true;
                } else if (index == 21) {
                    this.isBold = false;
                    this.isItalic = false;
                }
                ++i;
                on = false;
                continue;
            }
            if (on) {
                --i;
            }
            width += (int)(this.getPage().getWidth(text.charAt(i)) - 8.0f);
        }
        return width / 2;
    }

    public CharSequence trimStringToWidth(CharSequence text, int width) {
        return this.trimStringToWidth(text, width, false);
    }

    public CharSequence trimStringToWidth(CharSequence text, int maxWidth, boolean reverse) {
        StringBuilder sb = new StringBuilder();
        boolean on = false;
        int k = reverse ? -1 : 1;
        int width = 0;
        for (int j = reverse ? text.length() - 1 : 0; j >= 0 && j < text.length() && j < maxWidth; j += k) {
            char ch = text.charAt(j);
            if (ch == '\ufffd') {
                on = true;
            } else if (on && ch >= '0' && ch <= 'r') {
                int index = "0123456789abcdefklmnor".indexOf(ch);
                if (index < 16) {
                    this.isBold = false;
                    this.isItalic = false;
                } else if (index == 17) {
                    this.isBold = true;
                } else if (index == 20) {
                    this.isItalic = true;
                } else if (index == 21) {
                    this.isBold = false;
                    this.isItalic = false;
                }
                ++j;
                on = false;
            } else {
                if (on) {
                    --j;
                }
                ch = text.charAt(j);
                width += (int)((this.getPage().getWidth(ch) - 8.0f) / 2.0f);
            }
            if (j > width) break;
            if (reverse) {
                sb.insert(0, ch);
                continue;
            }
            sb.append(ch);
        }
        return EncryptedString.of(sb.toString());
    }
}

